/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.IllegalInstantException;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import water.MRTask;
import water.parser.BufferedString;
import water.util.Log;
import water.util.StringUtils;

public abstract class ParseTime {
    private static final byte[][][] MMS = new byte[][][]{new byte[][]{StringUtils.bytesOf("jan"), StringUtils.bytesOf("january")}, new byte[][]{StringUtils.bytesOf("feb"), StringUtils.bytesOf("february")}, new byte[][]{StringUtils.bytesOf("mar"), StringUtils.bytesOf("march")}, new byte[][]{StringUtils.bytesOf("apr"), StringUtils.bytesOf("april")}, new byte[][]{StringUtils.bytesOf("may"), StringUtils.bytesOf("may")}, new byte[][]{StringUtils.bytesOf("jun"), StringUtils.bytesOf("june")}, new byte[][]{StringUtils.bytesOf("jul"), StringUtils.bytesOf("july")}, new byte[][]{StringUtils.bytesOf("aug"), StringUtils.bytesOf("august")}, new byte[][]{StringUtils.bytesOf("sep"), StringUtils.bytesOf("september")}, new byte[][]{StringUtils.bytesOf("oct"), StringUtils.bytesOf("october")}, new byte[][]{StringUtils.bytesOf("nov"), StringUtils.bytesOf("november")}, new byte[][]{StringUtils.bytesOf("dec"), StringUtils.bytesOf("december")}};
    private static DateTimeZone _timezone = DateTimeZone.forID("UTC");

    public static boolean isTime(BufferedString str) {
        return ParseTime.attemptTimeParse(str) != Long.MIN_VALUE;
    }

    public static long attemptTimeParse(BufferedString str) {
        try {
            long t0 = ParseTime.attemptYearFirstTimeParse(str);
            if (t0 != Long.MIN_VALUE) {
                return t0;
            }
            long t1 = ParseTime.attemptDayFirstTimeParse1(str);
            if (t1 != Long.MIN_VALUE) {
                return t1;
            }
            long t2 = ParseTime.attemptYearMonthTimeParse(str);
            if (t2 != Long.MIN_VALUE) {
                return t2;
            }
            long t3 = ParseTime.attemptTimeOnlyParse(str);
            if (t3 != Long.MIN_VALUE) {
                return t3;
            }
            long t4 = ParseTime.attemptDayFirstTimeParse2(str);
            if (t4 != Long.MIN_VALUE) {
                return t4;
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalFieldValueException | IllegalInstantException runtimeException) {
            // empty catch block
        }
        return Long.MIN_VALUE;
    }

    private static long attemptYearFirstTimeParse(BufferedString str) {
        boolean dash;
        int i2;
        byte[] buf = str.getBuffer();
        int end = i2 + str.length();
        for (i2 = str.getOffset(); i2 < end && buf[i2] == 32; ++i2) {
        }
        if (i2 < end && buf[i2] == 34) {
            ++i2;
        }
        if (end - i2 < 6) {
            return Long.MIN_VALUE;
        }
        int yyyy = 0;
        int MM = 0;
        int dd = 0;
        yyyy = ParseTime.digit(yyyy, buf[i2++]);
        yyyy = ParseTime.digit(yyyy, buf[i2++]);
        yyyy = ParseTime.digit(yyyy, buf[i2++]);
        yyyy = ParseTime.digit(yyyy, buf[i2++]);
        boolean bl = dash = buf[i2] == 45;
        if (dash) {
            // empty if block
        }
        int n2 = ++i2;
        MM = ParseTime.digit(MM, buf[n2]);
        int n3 = MM = ++i2 < end && buf[i2] != 45 ? ParseTime.digit(MM, buf[i2++]) : MM;
        if (MM < 1 || MM > 12) {
            return Long.MIN_VALUE;
        }
        if (end - i2 >= 2) {
            if (dash && buf[i2++] != 45) {
                return Long.MIN_VALUE;
            }
            dd = ParseTime.digit(dd, buf[i2++]);
            int n4 = dd = i2 < end && buf[i2] >= 48 && buf[i2] <= 57 ? ParseTime.digit(dd, buf[i2++]) : dd;
            if (dd < 1 || dd > 31) {
                return Long.MIN_VALUE;
            }
        } else {
            if (!dash) {
                return Long.MIN_VALUE;
            }
            dd = 1;
        }
        if (dash) {
            while (i2 < end && buf[i2] == 32) {
                ++i2;
            }
            if (i2 == end) {
                return new DateTime(yyyy, MM, dd, 0, 0, 0, ParseTime.getTimezone()).getMillis();
            }
        } else if (i2 == end || buf[i2++] != 45) {
            return Long.MIN_VALUE;
        }
        return ParseTime.parseTime(buf, i2, end, yyyy, MM, dd, false);
    }

    private static long attemptDayFirstTimeParse1(BufferedString str) {
        int i2;
        byte[] buf = str.getBuffer();
        int end = i2 + str.length();
        for (i2 = str.getOffset(); i2 < end && buf[i2] == 32; ++i2) {
        }
        if (i2 < end && buf[i2] == 34) {
            ++i2;
        }
        if (end - i2 < 5) {
            return Long.MIN_VALUE;
        }
        int yyyy = 0;
        int MM = 0;
        int dd = 0;
        if (ParseTime.isDigit(buf[i2])) {
            dd = ParseTime.digit(dd, buf[i2++]);
            if (ParseTime.isDigit(buf[i2])) {
                dd = ParseTime.digit(dd, buf[i2++]);
            }
            if (dd < 1 || dd > 31) {
                return Long.MIN_VALUE;
            }
            if (buf[i2] == 45) {
                ++i2;
            }
        } else {
            dd = 1;
        }
        if (!ParseTime.isChar(buf[i2])) {
            return Long.MIN_VALUE;
        }
        MM = ParseTime.parseMonth(buf, i2, end);
        if (MM == -1) {
            return Long.MIN_VALUE;
        }
        i2 += MM >> 4;
        MM &= 0xF;
        if (end - i2 >= 1 && buf[i2] == 45) {
            ++i2;
        }
        if (end - i2 < 2) {
            return Long.MIN_VALUE;
        }
        yyyy = ParseTime.digit(yyyy, buf[i2++]);
        yyyy = ParseTime.digit(yyyy, buf[i2++]);
        if (end - i2 >= 2 && buf[i2] != 34 && buf[i2] != 32 && buf[i2] != 58) {
            yyyy = ParseTime.digit(yyyy, buf[i2++]);
            yyyy = ParseTime.digit(yyyy, buf[i2++]);
        } else {
            yyyy += yyyy >= 69 ? 1900 : 2000;
        }
        while (i2 < end && buf[i2] == 32) {
            ++i2;
        }
        if (i2 < end && buf[i2] == 34) {
            ++i2;
        }
        if (i2 == end) {
            return new DateTime(yyyy, MM, dd, 0, 0, 0, ParseTime.getTimezone()).getMillis();
        }
        if (buf[i2] == 58) {
            ++i2;
        }
        return ParseTime.parseTime(buf, i2, end, yyyy, MM, dd, false);
    }

    private static long attemptDayFirstTimeParse2(BufferedString str) {
        byte sep;
        int i2;
        byte[] buf = str.getBuffer();
        int end = i2 + str.length();
        for (i2 = str.getOffset(); i2 < end && buf[i2] == 32; ++i2) {
        }
        if (i2 < end && buf[i2] == 34) {
            ++i2;
        }
        if (end - i2 < 6) {
            return Long.MIN_VALUE;
        }
        int yyyy = 0;
        int MM = 0;
        int dd = 0;
        MM = ParseTime.digit(MM, buf[i2++]);
        if (ParseTime.isDigit(buf[i2])) {
            MM = ParseTime.digit(MM, buf[i2++]);
        }
        if (MM < 1 || MM > 12) {
            return Long.MIN_VALUE;
        }
        if ((sep = buf[i2++]) != 45 && sep != 47) {
            return Long.MIN_VALUE;
        }
        dd = ParseTime.digit(dd, buf[i2++]);
        if (ParseTime.isDigit(buf[i2])) {
            dd = ParseTime.digit(dd, buf[i2++]);
        }
        if (dd < 1 || dd > 31) {
            return Long.MIN_VALUE;
        }
        if (sep != buf[i2++]) {
            return Long.MIN_VALUE;
        }
        yyyy = ParseTime.digit(yyyy, buf[i2++]);
        yyyy = ParseTime.digit(yyyy, buf[i2++]);
        if (end - i2 >= 2 && ParseTime.isDigit(buf[i2])) {
            yyyy = ParseTime.digit(yyyy, buf[i2++]);
            yyyy = ParseTime.digit(yyyy, buf[i2++]);
        } else {
            yyyy += yyyy >= 69 ? 1900 : 2000;
        }
        while (i2 < end && buf[i2] == 32) {
            ++i2;
        }
        if (i2 < end && buf[i2] == 34) {
            ++i2;
        }
        if (i2 == end) {
            return new DateTime(yyyy, MM, dd, 0, 0, 0, ParseTime.getTimezone()).getMillis();
        }
        if (buf[i2] == 58) {
            ++i2;
        }
        return ParseTime.parseTime(buf, i2, end, yyyy, MM, dd, false);
    }

    private static long attemptYearMonthTimeParse(BufferedString str) {
        int i2;
        byte[] buf = str.getBuffer();
        int end = i2 + str.length();
        for (i2 = str.getOffset(); i2 < end && buf[i2] == 32; ++i2) {
        }
        if (i2 < end && buf[i2] == 34) {
            ++i2;
        }
        if (end - i2 < 6) {
            return Long.MIN_VALUE;
        }
        int yyyy = 0;
        int MM = 0;
        yyyy = ParseTime.digit(yyyy, buf[i2++]);
        yyyy = ParseTime.digit(yyyy, buf[i2++]);
        if (buf[i2++] != 45) {
            return Long.MIN_VALUE;
        }
        yyyy += yyyy >= 69 ? 1900 : 2000;
        MM = ParseTime.parseMonth(buf, i2, end);
        if (MM == -1) {
            return Long.MIN_VALUE;
        }
        i2 += MM >> 4;
        MM &= 0xF;
        while (i2 < end && buf[i2] == 32) {
            ++i2;
        }
        if (i2 == end) {
            return new DateTime(yyyy, MM, 1, 0, 0, 0, ParseTime.getTimezone()).getMillis();
        }
        return Long.MIN_VALUE;
    }

    private static long attemptTimeOnlyParse(BufferedString str) {
        int i2;
        byte[] buf = str.getBuffer();
        int end = i2 + str.length();
        for (i2 = str.getOffset(); i2 < end && buf[i2] == 32; ++i2) {
        }
        if (i2 < end && buf[i2] == 34) {
            ++i2;
        }
        if (end - i2 < 5) {
            return Long.MIN_VALUE;
        }
        long t1 = ParseTime.parseTime(buf, i2, end, 1970, 1, 1, true);
        if (t1 == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return t1 + (long)ParseTime.getTimezone().getOffsetFromLocal(t1);
    }

    private static int parseMonth(byte[] buf, int i2, int end) {
        int MM;
        byte[] MMM = null;
        block0: for (MM = 0; MM < MMS.length; ++MM) {
            byte[][] mss;
            block1: for (byte[] ms : mss = MMS[MM]) {
                MMM = ms;
                if (MMM == null || i2 + MMM.length > end) continue;
                for (int j2 = 0; j2 < MMM.length; ++j2) {
                    if (MMM[j2] != Character.toLowerCase(buf[i2 + j2])) continue block1;
                }
                if (i2 + MMM.length == end || buf[i2 + MMM.length] == 45 || ParseTime.isDigit(buf[i2 + MMM.length])) break block0;
            }
        }
        if (MM == MMS.length) {
            return -1;
        }
        return MMM.length << 4 | ++MM;
    }

    private static long parseTime(byte[] buf, int i2, int end, int yyyy, int MM, int dd, boolean timeOnly) {
        int HH = 0;
        int mm4 = 0;
        int ss = 0;
        int SSS = 0;
        int ndots = 0;
        HH = ParseTime.digit(HH, buf[i2++]);
        int n2 = HH = buf[i2] >= 48 && buf[i2] <= 57 ? ParseTime.digit(HH, buf[i2++]) : HH;
        if (HH < 0 || HH > 23) {
            return Long.MIN_VALUE;
        }
        if (buf[i2] != 58 && buf[i2] != 46) {
            return Long.MIN_VALUE;
        }
        if (buf[i2] == 46) {
            ++ndots;
        }
        int n3 = ++i2;
        mm4 = ParseTime.digit(mm4, buf[n3]);
        int n4 = mm4 = buf[++i2] >= 48 && buf[i2] <= 57 ? ParseTime.digit(mm4, buf[i2++]) : mm4;
        if (mm4 < 0 || mm4 > 59) {
            return Long.MIN_VALUE;
        }
        if (i2 + 2 >= buf.length) {
            return Long.MIN_VALUE;
        }
        if (buf[i2] != 58 && buf[i2] != 46) {
            return Long.MIN_VALUE;
        }
        if (buf[i2] == 46) {
            ++ndots;
        }
        int n5 = ++i2;
        ss = ParseTime.digit(ss, buf[n5]);
        int n6 = ss = buf[++i2] >= 48 && buf[i2] <= 57 ? ParseTime.digit(ss, buf[i2++]) : ss;
        if (ss < 0 || ss > 59) {
            return Long.MIN_VALUE;
        }
        if (i2 < end && (buf[i2] == 58 || buf[i2] == 46)) {
            if (buf[i2] == 46) {
                ++ndots;
            }
            if (++i2 < end) {
                SSS = ParseTime.digit(SSS, buf[i2++]);
            }
            if (i2 < end) {
                SSS = ParseTime.digit(SSS, buf[i2++]);
            }
            if (i2 < end) {
                SSS = ParseTime.digit(SSS, buf[i2++]);
            }
            if (SSS < 0 || SSS > 999) {
                return Long.MIN_VALUE;
            }
            while (i2 < end && ParseTime.isDigit(buf[i2])) {
                ++i2;
            }
        }
        if (i2 < end && buf[i2] == 34) {
            ++i2;
        }
        if (i2 == end) {
            if (timeOnly && ndots == 3) {
                return Long.MIN_VALUE;
            }
            return new DateTime(yyyy, MM, dd, HH, mm4, ss, ParseTime.getTimezone()).getMillis() + (long)SSS;
        }
        if (buf[i2] == 32 && ++i2 == end) {
            return new DateTime(yyyy, MM, dd, HH, mm4, ss, ParseTime.getTimezone()).getMillis() + (long)SSS;
        }
        if ((buf[i2] == 65 || buf[i2] == 80) && buf[i2 + 1] == 77) {
            if (HH < 1 || HH > 12) {
                return Long.MIN_VALUE;
            }
            if (buf[i2] == 80) {
                if (HH < 12) {
                    HH += 12;
                } else if (HH == 12) {
                    HH = 0;
                }
            }
        } else {
            return Long.MIN_VALUE;
        }
        if ((i2 += 2) < end && buf[i2] == 34) {
            ++i2;
        }
        if (i2 < end) {
            return Long.MIN_VALUE;
        }
        return new DateTime(yyyy, MM, dd, HH, mm4, ss, ParseTime.getTimezone()).getMillis() + (long)SSS;
    }

    private static int digit(int x2, int c2) {
        if (x2 < 0 || c2 < 48 || c2 > 57) {
            return -1;
        }
        return x2 * 10 + (c2 - 48);
    }

    private static boolean isDigit(byte b2) {
        return b2 >= 48 && b2 <= 57;
    }

    private static boolean isChar(byte b2) {
        return b2 >= 65 && (b2 <= 90 || b2 >= 97) && b2 <= 122;
    }

    public static void setTimezone(final String tz) {
        Set<String> idSet = DateTimeZone.getAvailableIDs();
        if (!idSet.contains(tz)) {
            Log.err("Attempted to set unrecognized timezone: " + tz);
            throw new IllegalArgumentException("Attempted to set unrecognized timezone: " + tz);
        }
        new MRTask(){

            @Override
            protected void setupLocal() {
                _timezone = DateTimeZone.forID(tz);
            }
        }.doAllNodes();
    }

    public static DateTimeZone getTimezone() {
        return _timezone == null ? DateTimeZone.getDefault() : _timezone;
    }

    public static String listTimezones() {
        DateTimeFormatter offsetFormatter = new DateTimeFormatterBuilder().appendTimeZoneOffset(null, true, 2, 4).toFormatter();
        Set<String> idSet = DateTimeZone.getAvailableIDs();
        TreeMap<String, String> tzMap = new TreeMap<String, String>();
        Iterator<String> it = idSet.iterator();
        boolean i2 = false;
        long millis = System.currentTimeMillis();
        while (it.hasNext()) {
            String id = it.next();
            DateTimeZone tz = DateTimeZone.forID(id);
            String cid = tz.getID();
            String offset = offsetFormatter.withZone(tz).print(tz.getStandardOffset(millis));
            String key = offset + " " + cid;
            if (id == cid) {
                if (tzMap.containsKey(key)) continue;
                tzMap.put(key, "");
                continue;
            }
            if (!tzMap.containsKey(key)) {
                tzMap.put(key, "");
            }
            tzMap.put(key, (String)tzMap.get(key) + ", " + id);
        }
        String output = "StandardOffset CanonicalID, Aliases\n";
        for (Map.Entry e2 : tzMap.entrySet()) {
            output = output + (String)e2.getKey() + (String)e2.getValue() + "\n";
        }
        return output;
    }

    public static DateTimeFormatter forStrptimePattern(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("Empty date time pattern specification");
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        ParseTime.parseToBuilder(builder, pattern);
        DateTimeFormatter formatter = builder.toFormatter();
        return formatter;
    }

    private static void parseToBuilder(DateTimeFormatterBuilder builder, String pattern) {
        int length = pattern.length();
        int[] indexRef = new int[1];
        for (int i2 = 0; i2 < length; ++i2) {
            indexRef[0] = i2;
            String token = ParseTime.parseToken(pattern, indexRef);
            i2 = indexRef[0];
            int tokenLen = token.length();
            if (tokenLen == 0) break;
            char c2 = token.charAt(0);
            if (c2 == '%' && token.charAt(1) != '%') {
                c2 = token.charAt(1);
                switch (c2) {
                    case 'a': {
                        builder.appendDayOfWeekShortText();
                        break;
                    }
                    case 'A': {
                        builder.appendDayOfWeekText();
                        break;
                    }
                    case 'b': 
                    case 'h': {
                        builder.appendMonthOfYearShortText();
                        break;
                    }
                    case 'B': {
                        builder.appendMonthOfYearText();
                        break;
                    }
                    case 'c': {
                        builder.appendDayOfWeekShortText();
                        builder.appendLiteral(' ');
                        builder.appendMonthOfYearShortText();
                        builder.appendLiteral(' ');
                        builder.appendDayOfMonth(2);
                        builder.appendLiteral(' ');
                        builder.appendHourOfDay(2);
                        builder.appendLiteral(':');
                        builder.appendMinuteOfHour(2);
                        builder.appendLiteral(':');
                        builder.appendSecondOfMinute(2);
                        builder.appendLiteral(' ');
                        builder.appendYear(4, 4);
                        break;
                    }
                    case 'C': {
                        builder.appendCenturyOfEra(1, 2);
                        break;
                    }
                    case 'd': {
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'D': {
                        builder.appendMonthOfYear(2);
                        builder.appendLiteral('/');
                        builder.appendDayOfMonth(2);
                        builder.appendLiteral('/');
                        builder.appendTwoDigitYear(2019);
                        break;
                    }
                    case 'e': {
                        builder.appendOptional(DateTimeFormat.forPattern("' '").getParser());
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'F': {
                        builder.appendYear(4, 4);
                        builder.appendLiteral('-');
                        builder.appendMonthOfYear(2);
                        builder.appendLiteral('-');
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        break;
                    }
                    case 'H': {
                        builder.appendHourOfDay(2);
                        break;
                    }
                    case 'I': {
                        builder.appendClockhourOfHalfday(2);
                        break;
                    }
                    case 'j': {
                        builder.appendDayOfYear(3);
                        break;
                    }
                    case 'k': {
                        builder.appendOptional(DateTimeFormat.forPattern("' '").getParser());
                        builder.appendHourOfDay(2);
                        break;
                    }
                    case 'l': {
                        builder.appendOptional(DateTimeFormat.forPattern("' '").getParser());
                        builder.appendClockhourOfHalfday(2);
                        break;
                    }
                    case 'm': {
                        builder.appendMonthOfYear(2);
                        break;
                    }
                    case 'M': {
                        builder.appendMinuteOfHour(2);
                        break;
                    }
                    case 'n': {
                        break;
                    }
                    case 'p': {
                        builder.appendHalfdayOfDayText();
                        break;
                    }
                    case 'r': {
                        builder.appendClockhourOfHalfday(2);
                        builder.appendLiteral(':');
                        builder.appendMinuteOfHour(2);
                        builder.appendLiteral(':');
                        builder.appendSecondOfMinute(2);
                        builder.appendLiteral(' ');
                        builder.appendHalfdayOfDayText();
                        break;
                    }
                    case 'R': {
                        builder.appendHourOfDay(2);
                        builder.appendLiteral(':');
                        builder.appendMinuteOfHour(2);
                        break;
                    }
                    case 'S': {
                        builder.appendSecondOfMinute(2);
                        break;
                    }
                    case 't': {
                        break;
                    }
                    case 'T': {
                        builder.appendHourOfDay(2);
                        builder.appendLiteral(':');
                        builder.appendMinuteOfHour(2);
                        builder.appendLiteral(':');
                        builder.appendSecondOfMinute(2);
                        break;
                    }
                    case 'V': {
                        break;
                    }
                    case 'x': {
                        builder.appendTwoDigitYear(2019);
                        builder.appendLiteral('/');
                        builder.appendMonthOfYear(2);
                        builder.appendLiteral('/');
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'y': {
                        builder.appendTwoDigitYear(2019);
                        break;
                    }
                    case 'Y': {
                        builder.appendYear(4, 4);
                        break;
                    }
                    case 'z': {
                        builder.appendTimeZoneOffset(null, "z", false, 2, 2);
                        break;
                    }
                    case 'Z': {
                        break;
                    }
                    default: {
                        builder.appendLiteral('\'');
                        builder.appendLiteral(token);
                        Log.warn(token + "is not acceptted as a parse token, treating as a literal");
                        break;
                    }
                }
                continue;
            }
            if (c2 == '\'') {
                String sub = token.substring(1);
                if (sub.length() <= 0) continue;
                builder.appendLiteral(new String(sub));
                continue;
            }
            throw new IllegalArgumentException("Unexpected token encountered parsing format string:" + c2);
        }
    }

    private static String parseToken(String pattern, int[] indexRef) {
        StringBuilder buf = new StringBuilder();
        int i2 = indexRef[0];
        int length = pattern.length();
        char c2 = pattern.charAt(i2);
        if (c2 == '%' && i2 + 1 < length && pattern.charAt(i2 + 1) != '%') {
            if (((c2 = pattern.charAt(++i2)) == '0' || c2 == 'E') && i2 + 1 >= length) {
                c2 = pattern.charAt(++i2);
            }
            buf.append('%');
            buf.append(c2);
        } else {
            buf.append('\'');
            buf.append(c2);
            ++i2;
            while (i2 < length) {
                c2 = pattern.charAt(i2);
                if (c2 == '%') {
                    if (i2 + 1 >= length || pattern.charAt(i2 + 1) != '%') break;
                    ++i2;
                }
                buf.append(c2);
                ++i2;
            }
        }
        indexRef[0] = --i2;
        return buf.toString();
    }
}

