/*
 * Decompiled with CFR 0.152.
 */
package water.parser.avro;

import water.DKV;
import water.Job;
import water.Key;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.ByteVec;
import water.fvec.Frame;
import water.parser.ParseSetup;
import water.parser.Parser;
import water.parser.ParserInfo;
import water.parser.ParserProvider;
import water.parser.avro.AvroParser;

public class AvroParserProvider
extends ParserProvider {
    static ParserInfo AVRO_INFO = new ParserInfo("AVRO", 10010, true, true);

    @Override
    public ParserInfo info() {
        return AVRO_INFO;
    }

    @Override
    public Parser createParser(ParseSetup setup, Key<Job> jobKey) {
        return new AvroParser(setup, jobKey);
    }

    @Override
    public ParseSetup guessSetup(ByteVec bv, byte[] bits, byte sep, int ncols, boolean singleQuotes, int checkHeader, String[] columnNames, byte[] columnTypes, String[][] domains, String[][] naStrings) {
        return AvroParser.guessSetup(bits);
    }

    @Override
    public ParseSetup createParserSetup(Key[] inputs, ParseSetup requiredSetup) {
        assert (inputs != null && inputs.length > 0) : "Inputs cannot be empty!";
        Key firstInput = inputs[0];
        Object ice = DKV.getGet(firstInput);
        if (ice == null) {
            throw new H2OIllegalArgumentException("Missing data", "Did not find any data under key " + firstInput);
        }
        ByteVec bv = (ByteVec)(ice instanceof ByteVec ? ice : ((Frame)ice).vecs()[0]);
        byte[] bits = bv.getFirstBytes();
        try {
            AvroParser.AvroInfo avroInfo = AvroParser.extractAvroInfo(bits, requiredSetup);
            return new AvroParser.AvroParseSetup(requiredSetup, avroInfo.header, avroInfo.firstBlockSize, avroInfo.domains);
        }
        catch (Throwable e2) {
            throw new H2OIllegalArgumentException("Wrong data", "Cannot find Avro header in input file: " + firstInput, e2);
        }
    }
}

