/*
 * Decompiled with CFR 0.152.
 */
package water.parser.avro;

import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;

public final class AvroUtil {
    public static boolean isSupportedSchema(Schema s2) {
        Schema.Type typ = s2.getType();
        switch (typ) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case ENUM: 
            case STRING: 
            case NULL: 
            case BYTES: {
                return true;
            }
            case UNION: {
                List unionSchemas = s2.getTypes();
                if (unionSchemas.size() == 1) {
                    return AvroUtil.isSupportedSchema((Schema)unionSchemas.get(0));
                }
                if (unionSchemas.size() != 2) break;
                Schema s1 = (Schema)unionSchemas.get(0);
                Schema s22 = (Schema)unionSchemas.get(1);
                return s1.getType().equals((Object)Schema.Type.NULL) && AvroUtil.isSupportedSchema(s22) || s22.getType().equals((Object)Schema.Type.NULL) && AvroUtil.isSupportedSchema(s1);
            }
        }
        return false;
    }

    public static byte schemaToColumnType(Schema s2) {
        Schema.Type typ = s2.getType();
        switch (typ) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return 3;
            }
            case ENUM: {
                return 4;
            }
            case STRING: {
                return 2;
            }
            case NULL: {
                return 0;
            }
            case BYTES: {
                return 2;
            }
            case UNION: {
                List unionSchemas = s2.getTypes();
                if (unionSchemas.size() == 1) {
                    return AvroUtil.schemaToColumnType((Schema)unionSchemas.get(0));
                }
                if (unionSchemas.size() != 2) break;
                Schema s1 = (Schema)unionSchemas.get(0);
                Schema s22 = (Schema)unionSchemas.get(1);
                if (s1.getType().equals((Object)Schema.Type.NULL)) {
                    return AvroUtil.schemaToColumnType(s22);
                }
                if (!s22.getType().equals((Object)Schema.Type.NULL)) break;
                return AvroUtil.schemaToColumnType(s1);
            }
        }
        throw new IllegalArgumentException("Unsupported Avro schema type: " + s2);
    }

    static String[] getDomain(Schema fieldSchema) {
        if (fieldSchema.getType() == Schema.Type.ENUM) {
            return fieldSchema.getEnumSymbols().toArray(new String[0]);
        }
        if (fieldSchema.getType() == Schema.Type.UNION) {
            List unionSchemas = fieldSchema.getTypes();
            if (unionSchemas.size() == 1) {
                return AvroUtil.getDomain((Schema)unionSchemas.get(0));
            }
            if (unionSchemas.size() == 2) {
                Schema s1 = (Schema)unionSchemas.get(0);
                Schema s2 = (Schema)unionSchemas.get(1);
                if (s1.getType() == Schema.Type.NULL) {
                    return AvroUtil.getDomain(s2);
                }
                if (s2.getType() == Schema.Type.NULL) {
                    return AvroUtil.getDomain(s1);
                }
            }
        }
        throw new IllegalArgumentException("Cannot get domain from field: " + fieldSchema);
    }

    public static Schema.Type toPrimitiveType(Schema s2) {
        Schema.Type typ = s2.getType();
        switch (typ) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case ENUM: 
            case STRING: 
            case NULL: 
            case BYTES: {
                return typ;
            }
            case UNION: {
                List unionSchemas = s2.getTypes();
                if (unionSchemas.size() == 1) {
                    return AvroUtil.toPrimitiveType((Schema)unionSchemas.get(0));
                }
                if (unionSchemas.size() != 2) break;
                Schema s1 = (Schema)unionSchemas.get(0);
                Schema s22 = (Schema)unionSchemas.get(1);
                if (s1.getType().equals((Object)Schema.Type.NULL)) {
                    return AvroUtil.toPrimitiveType(s22);
                }
                if (!s22.getType().equals((Object)Schema.Type.NULL)) break;
                return AvroUtil.toPrimitiveType(s1);
            }
        }
        throw new IllegalArgumentException("Unsupported Avro schema type: " + s2);
    }

    public static Schema.Field[] flatSchema(Schema s2) {
        List fields = s2.getFields();
        Schema.Field[] flatSchema = new Schema.Field[fields.size()];
        int cnt = 0;
        for (Schema.Field f2 : fields) {
            if (!AvroUtil.isSupportedSchema(f2.schema())) continue;
            flatSchema[cnt] = f2;
            ++cnt;
        }
        return cnt != flatSchema.length ? Arrays.copyOf(flatSchema, cnt) : flatSchema;
    }
}

