/*
 * Decompiled with CFR 0.152.
 */
package water.parser.orc;

public final class OrcUtil {
    public static boolean isSupportedSchema(String s2) {
        switch (s2.toLowerCase()) {
            case "boolean": 
            case "bigint": 
            case "char": 
            case "date": 
            case "decimal": 
            case "double": 
            case "float": 
            case "int": 
            case "smallint": 
            case "string": 
            case "timestamp": 
            case "tinyint": 
            case "varchar": 
            case "enum": {
                return true;
            }
        }
        return false;
    }

    public static byte schemaToColumnType(String s2) {
        switch (s2.toLowerCase()) {
            case "boolean": 
            case "smallint": 
            case "tinyint": 
            case "bigint": 
            case "int": 
            case "float": 
            case "double": 
            case "decimal": {
                return 3;
            }
            case "timestamp": 
            case "date": {
                return 5;
            }
            case "enum": {
                return 4;
            }
            case "string": 
            case "varchar": 
            case "char": {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unsupported Orc schema type: " + s2);
    }
}

