/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import water.DKV;
import water.Job;
import water.Key;
import water.fvec.ByteVec;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BinaryParserProvider;
import water.parser.ParseSetup;
import water.parser.ParseWriter;
import water.parser.Parser;
import water.parser.ParserInfo;
import water.parser.parquet.ParquetParser;
import water.parser.parquet.VecParquetReader;

public class ParquetParserProvider
extends BinaryParserProvider {
    static ParserInfo PARQUET_INFO = new ParserInfo("PARQUET", 10020, true, false, true, false);

    @Override
    public ParserInfo info() {
        return PARQUET_INFO;
    }

    @Override
    public Parser createParser(ParseSetup setup, Key<Job> jobKey) {
        return new ParquetParser(setup, jobKey);
    }

    @Override
    public ParseSetup guessInitSetup(ByteVec v2, byte[] bits, ParseSetup userSetup) {
        return ParquetParser.guessFormatSetup(v2, bits);
    }

    @Override
    public ParseSetup guessFinalSetup(ByteVec v2, byte[] bits, ParseSetup ps) {
        boolean[] keepColumns = null;
        int[] parseColumnIndices = ps.get_parse_columns_indices();
        if (parseColumnIndices != null) {
            int numCols = ps.getNumberColumns();
            keepColumns = new boolean[numCols];
            for (int cindex : parseColumnIndices) {
                keepColumns[cindex] = true;
            }
        }
        return ParquetParser.guessDataSetup(v2, (ParquetParser.ParquetParseSetup)ps, keepColumns);
    }

    @Override
    public ParseSetup createParserSetup(Key[] inputs, ParseSetup requestedSetup) {
        ParseSetup setup = requestedSetup instanceof ParquetParser.ParquetParseSetup ? requestedSetup : requestedSetup.copyTo(new ParquetParser.ParquetParseSetup());
        Object frameOrVec = DKV.getGet(inputs[0]);
        ByteVec vec = (ByteVec)(frameOrVec instanceof Frame ? ((Frame)frameOrVec).vec(0) : frameOrVec);
        byte[] requestedTypes = setup.getColumnTypes();
        byte[] types2 = ParquetParser.correctTypeConversions(vec, requestedTypes);
        setup.setColumnTypes(types2);
        for (int i2 = 0; i2 < types2.length; ++i2) {
            if (types2[i2] == requestedTypes[i2]) continue;
            setup.addErrs(new ParseWriter.UnsupportedTypeOverride(inputs[0].toString(), Vec.TYPE_STR[types2[i2]], Vec.TYPE_STR[requestedTypes[i2]], setup.getColumnNames()[i2]));
        }
        return setup;
    }

    @Override
    public ParseSetup setupLocal(Vec v2, ParseSetup setup) {
        ((ParquetParser.ParquetParseSetup)setup).parquetMetadata = VecParquetReader.readFooterAsBytes(v2);
        return setup;
    }
}

