/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import java.util.Arrays;
import water.DKV;
import water.Key;
import water.parser.BufferedString;
import water.parser.ParseWriter;
import water.util.IcedInt;
import water.util.Log;

final class WriterDelegate {
    private final int _maxStringSize = this.getMaxStringSize();
    private final int[] _colRawSize;
    private final int _numCols;
    private ParseWriter _writer;
    private int _col;

    WriterDelegate(ParseWriter writer, int numCols) {
        this._numCols = numCols;
        this._colRawSize = new int[numCols];
        this.setWriter(writer);
    }

    private int getMaxStringSize() {
        Object maxSize = DKV.getGet(Key.make(WriterDelegate.class.getCanonicalName() + "_maxStringSize"));
        return maxSize instanceof IcedInt ? ((IcedInt)maxSize)._val : 0x7FFFFFF6;
    }

    void startLine() {
        this._col = -1;
    }

    void endLine() {
        this.moveToCol(this._numCols);
        this._writer.newLine();
    }

    private int moveToCol(int colIdx) {
        for (int c2 = this._col + 1; c2 < colIdx; ++c2) {
            this._writer.addInvalidCol(c2);
        }
        this._col = colIdx;
        return this._col;
    }

    void addNumCol(int colIdx, long number, int exp) {
        this._writer.addNumCol(this.moveToCol(colIdx), number, exp);
    }

    void addNumCol(int colIdx, double d2) {
        this._writer.addNumCol(this.moveToCol(colIdx), d2);
    }

    void addStrCol(int colIdx, BufferedString str) {
        if (this._colRawSize[colIdx] == -1) {
            return;
        }
        long totalSize = (long)str.length() + (long)this._colRawSize[colIdx];
        if (totalSize > (long)this._maxStringSize) {
            this._colRawSize[colIdx] = -1;
            Log.err("Total String size limit reached: skipping remaining values in column: " + colIdx + "!");
            return;
        }
        int n2 = colIdx;
        this._colRawSize[n2] = this._colRawSize[n2] + str.length();
        this._writer.addStrCol(this.moveToCol(colIdx), str);
    }

    long lineNum() {
        return this._writer.lineNum();
    }

    final void setWriter(ParseWriter writer) {
        this._writer = writer;
        this._col = Integer.MIN_VALUE;
        Arrays.fill(this._colRawSize, 0);
    }
}

