/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import water.Futures;
import water.H2O;
import water.Key;
import water.MemoryManager;
import water.Value;
import water.api.HDFSIOException;
import water.fvec.FileVec;
import water.fvec.HDFSFileVec;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.persist.Persist;
import water.persist.S3ATokenRefresherFactory;
import water.persist.VecDataInputStream;
import water.util.FileUtils;
import water.util.Log;

public final class PersistHdfs
extends Persist {
    public static final Configuration CONF;
    private final Path _iceRoot = null;
    private static final List<S3ATokenRefresherFactory> _refreshers;
    private static final PathFilter HIDDEN_FILE_FILTER;

    static void configureFromProperties(Configuration conf, Properties props) {
        for (Object propertyKey : Collections.list(props.keys())) {
            String propertyValue = props.getProperty((String)propertyKey);
            conf.set((String)propertyKey, propertyValue);
        }
    }

    @Override
    public void cleanUp() {
        throw H2O.unimpl();
    }

    @Override
    public byte[] load(Value v2) {
        assert (v2.isPersisted());
        Key k2 = v2._key;
        long skip = k2.isChunkKey() ? NFSFileVec.chunkOffset(k2) : 0L;
        return this.load(k2, skip, v2._max);
    }

    @Override
    public byte[] load(Key k2, long skip, int max) {
        Path p2 = this._iceRoot == null ? new Path(FileVec.getPathForKey(k2)) : new Path(this._iceRoot, PersistHdfs.getIceName(k2));
        return this.load(p2, skip, max);
    }

    private byte[] load(Path p2, long skip, int max) {
        long start = System.currentTimeMillis();
        byte[] b2 = MemoryManager.malloc1(max);
        PersistHdfs.run(() -> {
            FileSystem fs = FileSystem.get((URI)p2.toUri(), (Configuration)CONF);
            FSDataInputStream s2 = null;
            try {
                s2 = fs.open(p2);
                s2.seek(skip);
                s2.readFully(b2);
                if (s2 == null) return null;
            }
            catch (Throwable throwable) {
                if (s2 == null) throw throwable;
                FileUtils.close(s2.getWrappedStream());
                FileUtils.closeSilently(new Closeable[]{s2});
                throw throwable;
            }
            FileUtils.close(s2.getWrappedStream());
            FileUtils.closeSilently(new Closeable[]{s2});
            return null;
        });
        long end = System.currentTimeMillis();
        if (end - start > 1000L) {
            Log.debug("Slow Read: " + (end - start) + " millis to get bytes " + skip + "-" + (skip + (long)b2.length) + " in HDFS read.");
        }
        return b2;
    }

    @Override
    public void store(Value v2) {
        assert (this == H2O.getPM().getIce());
        assert (!v2.isPersisted());
        byte[] m4 = v2.memOrLoad();
        assert (m4 == null || m4.length == v2._max);
        PersistHdfs.store(new Path(this._iceRoot, PersistHdfs.getIceName(v2)), m4);
    }

    private static void store(Path path, byte[] data) {
        PersistHdfs.run(() -> {
            FileSystem fs = PersistHdfs.getFileSystem(path, true);
            fs.mkdirs(path.getParent());
            try (FSDataOutputStream s2 = fs.create(path);){
                s2.write(data);
            }
            return null;
        });
    }

    @Override
    public void delete(Value v2) {
        assert (this == H2O.getPM().getIce());
        assert (!v2.isPersisted());
        PersistHdfs.run(() -> {
            Path p2 = new Path(this._iceRoot, PersistHdfs.getIceName(v2));
            FileSystem fs = PersistHdfs.getFileSystem(p2, true);
            fs.delete(p2, true);
            return null;
        });
    }

    private static void run(Callable<?> c2) {
        while (true) {
            try {
                c2.call();
            }
            catch (EOFException e2) {
                PersistHdfs.ignoreAndWait(e2, true);
                continue;
            }
            catch (SocketTimeoutException e3) {
                PersistHdfs.ignoreAndWait(e3, false);
                continue;
            }
            catch (IOException e4) {
                PersistHdfs.ignoreAndWait(e4, e4.getClass().getName().contains("S3Exception"));
                continue;
            }
            catch (RuntimeException e5) {
                if (e5.getClass().getName().contains("S3Exception")) {
                    PersistHdfs.ignoreAndWait(e5, false);
                    continue;
                }
                throw Log.throwErr(e5);
            }
            catch (Exception e6) {
                throw Log.throwErr(e6);
            }
            break;
        }
    }

    private static void ignoreAndWait(Exception e2, boolean printException) {
        Log.ignore(e2, "Hit HDFS reset problem, retrying...", printException);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void addFolder(Path p2, ArrayList<String> keys, ArrayList<String> failed) throws IOException, RuntimeException {
        FileSystem fs = PersistHdfs.getFileSystem(p2, false);
        if (!fs.exists(p2)) {
            failed.add("Path does not exist: '" + p2.toString() + "'");
            return;
        }
        PersistHdfs.addFolder(fs, p2, keys, failed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFolder(FileSystem fs, Path p2, ArrayList<String> keys, ArrayList<String> failed) {
        if (fs == null) {
            return;
        }
        Futures futures = new Futures();
        try {
            for (FileStatus file : fs.listStatus(p2, HIDDEN_FILE_FILTER)) {
                Path pfs = file.getPath();
                if (file.isDirectory()) {
                    PersistHdfs.addFolder(fs, pfs, keys, failed);
                    continue;
                }
                if (file.getLen() <= 0L) continue;
                Key k2 = HDFSFileVec.make(pfs.toString(), file.getLen(), futures);
                keys.add(k2.toString());
                Log.debug("PersistHdfs: DKV.put(" + k2 + ")");
            }
        }
        catch (Exception e2) {
            Log.err(e2);
            failed.add(p2.toString());
        }
        finally {
            futures.blockForPending();
        }
    }

    @Override
    public Key uriToKey(URI uri) throws IOException {
        assert ("hdfs".equals(uri.getScheme()) || "s3".equals(uri.getScheme()) || "s3n".equals(uri.getScheme()) || "s3a".equals(uri.getScheme())) : "Expected hdfs, s3 s3n, or s3a scheme, but uri is " + uri;
        Path path = new Path(uri);
        FileSystem fs = PersistHdfs.getFileSystem(path, false);
        FileStatus[] fstatus = fs.listStatus(path);
        assert (fstatus.length == 1) : "Expected uri to single file, but uri is " + uri;
        return HDFSFileVec.make(fstatus[0].getPath().toString(), fstatus[0].getLen());
    }

    private boolean isBareS3NBucketWithoutTrailingSlash(String s2) {
        String s22 = s2.toLowerCase();
        Matcher m4 = Pattern.compile("s3n://[^/]*").matcher(s22);
        return m4.matches();
    }

    public ArrayList<String> calcTypeaheadMatches(String filter, int limit) {
        if (this.isBareS3NBucketWithoutTrailingSlash(filter)) {
            filter = filter + "/";
        }
        ArrayList<String> array = new ArrayList<String>();
        String s2 = filter.toLowerCase();
        if ("hdfs:".equals(s2)) {
            return array;
        }
        if ("maprfs:".equals(s2)) {
            return array;
        }
        try {
            Path p2;
            Path expand = p2 = new Path(filter);
            if (!filter.endsWith("/")) {
                expand = p2.getParent();
            }
            FileSystem fs = PersistHdfs.getFileSystem(p2, false);
            for (FileStatus file : fs.listStatus(expand)) {
                Path fp = file.getPath();
                if (fp.toString().startsWith(p2.toString())) {
                    array.add(fp.toString());
                }
                if (array.size() != limit) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e2) {
            Log.trace(e2);
        }
        catch (Throwable t2) {
            Log.warn(t2);
        }
        return array;
    }

    @Override
    public void importFiles(String path, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        if (this.isBareS3NBucketWithoutTrailingSlash(path)) {
            path = path + "/";
        }
        Log.info("ImportHDFS processing (" + path + ")");
        try {
            PersistHdfs.addFolder(new Path(path), keys, fails);
            files.addAll(keys);
        }
        catch (IOException e2) {
            throw new HDFSIOException(path, CONF.toString(), e2);
        }
    }

    @Override
    public String getHomeDirectory() {
        try {
            FileSystem fs = FileSystem.get((Configuration)CONF);
            return fs.getHomeDirectory().toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    @Override
    public Persist.PersistEntry[] list(String path) {
        try {
            Path p2 = new Path(path);
            FileSystem fs = PersistHdfs.getFileSystem(p2, false);
            FileStatus[] arr1 = fs.listStatus(p2);
            Persist.PersistEntry[] arr2 = new Persist.PersistEntry[arr1.length];
            for (int i2 = 0; i2 < arr1.length; ++i2) {
                arr2[i2] = new Persist.PersistEntry(arr1[i2].getPath().getName(), arr1[i2].getLen(), arr1[i2].getModificationTime());
            }
            return arr2;
        }
        catch (IOException e2) {
            throw new HDFSIOException(path, CONF.toString(), e2);
        }
    }

    @Override
    public boolean exists(String path) {
        Path p2 = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p2, false);
            return fs.exists(p2);
        }
        catch (IOException e2) {
            throw new HDFSIOException(path, CONF.toString(), e2);
        }
    }

    @Override
    public String getParent(String path) {
        Path p2 = new Path(path);
        return p2.getParent().toUri().toString();
    }

    @Override
    public boolean isDirectory(String path) {
        Path p2 = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p2, false);
            return fs.isDirectory(p2);
        }
        catch (IOException e2) {
            throw new HDFSIOException(path, CONF.toString(), e2);
        }
    }

    @Override
    public long length(String path) {
        Path p2 = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p2, false);
            return fs.getFileStatus(p2).getLen();
        }
        catch (IOException e2) {
            throw new HDFSIOException(path, CONF.toString(), e2);
        }
    }

    @Override
    public InputStream open(String path) {
        return this.openSeekable(path);
    }

    @Override
    public InputStream openSeekable(String path) {
        Path p2 = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p2, false);
            return fs.open(p2);
        }
        catch (IOException e2) {
            throw new HDFSIOException(path, CONF.toString(), e2);
        }
    }

    @Override
    public InputStream wrapSeekable(Vec vec) {
        return new FSDataInputStream((InputStream)new VecDataInputStream(vec, true));
    }

    @Override
    public boolean isSeekableOpenSupported() {
        return true;
    }

    @Override
    public boolean mkdirs(String path) {
        Path p2 = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p2, false);
            if (fs.exists(p2)) {
                return false;
            }
            return fs.mkdirs(p2);
        }
        catch (IOException e2) {
            throw new HDFSIOException(path, CONF.toString(), e2);
        }
    }

    @Override
    public boolean rename(String fromPath, String toPath) {
        Path f2 = new Path(fromPath);
        Path t2 = new Path(toPath);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(f2, false);
            return fs.rename(f2, t2);
        }
        catch (IOException e2) {
            throw new HDFSIOException(toPath, CONF.toString(), e2);
        }
    }

    @Override
    public OutputStream create(String path, boolean overwrite) {
        Path p2 = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p2, false);
            return fs.create(p2, overwrite);
        }
        catch (IOException e2) {
            throw new HDFSIOException(path, CONF.toString(), e2);
        }
    }

    @Override
    public boolean delete(String path) {
        Path p2 = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p2, false);
            return fs.delete(p2, true);
        }
        catch (IOException e2) {
            throw new HDFSIOException(path, CONF.toString(), e2);
        }
    }

    @Override
    public boolean canHandle(String path) {
        URI uri = new Path(path).toUri();
        try {
            return uri.getScheme() != null && FileSystem.getFileSystemClass((String)uri.getScheme(), (Configuration)CONF) != null;
        }
        catch (IOException e2) {
            return false;
        }
    }

    private static FileSystem getFileSystem(Path path, boolean assumeTokensAcquired) throws IOException {
        block1: {
            S3ATokenRefresherFactory refresherFactory;
            boolean handled;
            if (assumeTokensAcquired || _refreshers.size() <= 0) break block1;
            Iterator<S3ATokenRefresherFactory> iterator = _refreshers.iterator();
            while (iterator.hasNext() && !(handled = (refresherFactory = iterator.next()).startDelegationTokenRefresher(path))) {
            }
        }
        return FileSystem.get((URI)path.toUri(), (Configuration)CONF);
    }

    public static void registerRefresherFactory(S3ATokenRefresherFactory refresherFactory) {
        _refreshers.add(refresherFactory);
    }

    static {
        _refreshers = new LinkedList<S3ATokenRefresherFactory>();
        HIDDEN_FILE_FILTER = new PathFilter(){

            public boolean accept(Path p2) {
                return !p2.getName().startsWith(".");
            }
        };
        Configuration conf = new Configuration();
        if (H2O.ARGS.hdfs_config != null && H2O.ARGS.hdfs_config.length > 0) {
            for (String config : H2O.ARGS.hdfs_config) {
                File p2 = new File(config);
                if (!p2.exists()) {
                    H2O.die("Unable to open hdfs configuration file " + p2.getAbsolutePath());
                }
                conf.addResource(new Path(p2.getAbsolutePath()));
                Log.debug("resource ", p2.getAbsolutePath(), " added to the hadoop configuration");
            }
        } else {
            Path confDir = null;
            if (System.getenv().containsKey("HADOOP_CONF_DIR")) {
                confDir = new Path(System.getenv("HADOOP_CONF_DIR"));
            } else if (System.getenv().containsKey("YARN_CONF_DIR")) {
                confDir = new Path(System.getenv("YARN_CONF_DIR"));
            } else if (System.getenv().containsKey("HADOOP_HOME")) {
                confDir = new Path(System.getenv("HADOOP_HOME"), "conf");
            }
            if (confDir != null) {
                Log.info("Using HDFS configuration from " + confDir);
                conf.addResource(new Path(confDir, "core-site.xml"));
            } else {
                Log.debug("Cannot find HADOOP_CONF_DIR or YARN_CONF_DIR - default HDFS properties are NOT loaded!");
            }
        }
        PersistHdfs.configureFromProperties(conf, H2O.ARGS.hadoop_properties);
        CONF = conf;
    }
}

