/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import water.DKV;
import water.Freezable;
import water.H2O;
import water.Key;
import water.Value;
import water.fvec.C1NChunk;
import water.persist.Persist;

public class PersistHex
extends Persist {
    static final String HEX_PATH_PREFIX = "hex://";

    Key<?> fromHexPath(String path) {
        Key key = Key.make(path.substring(HEX_PATH_PREFIX.length()));
        if (!key.isChunkKey()) {
            throw new IllegalArgumentException("Only Chunk keys are supported for HEX schema");
        }
        return key;
    }

    InputStream open(Key<?> key) {
        Objects.requireNonNull(key);
        byte[] bytes = ((C1NChunk)DKV.getGet(key)).getBytes();
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public InputStream open(String path) {
        return this.open(this.fromHexPath(path));
    }

    @Override
    public OutputStream create(String path, boolean overwrite) {
        Key<?> ck = this.fromHexPath(path);
        return new ByteChunkOutputStream(ck);
    }

    @Override
    public List<String> calcTypeaheadMatches(String filter, int limit) {
        throw H2O.unimpl();
    }

    @Override
    public void importFiles(String path, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        throw H2O.unimpl();
    }

    @Override
    public Key uriToKey(URI uri) {
        throw H2O.unimpl();
    }

    @Override
    public void store(Value v2) {
        if (!v2._key.home()) {
            return;
        }
        throw H2O.unimpl();
    }

    @Override
    public void delete(Value v2) {
        throw H2O.unimpl();
    }

    @Override
    public void cleanUp() {
        throw H2O.unimpl();
    }

    @Override
    public byte[] load(Value v2) {
        throw H2O.unimpl();
    }

    private static class ByteChunkOutputStream
    extends ByteArrayOutputStream {
        private final Key<?> _chunkKey;

        public ByteChunkOutputStream(Key<?> chunkKey) {
            this._chunkKey = chunkKey;
        }

        @Override
        public void close() throws IOException {
            super.close();
            byte[] myBytes = this.toByteArray();
            DKV.put(this._chunkKey, new Value(this._chunkKey, (Freezable)new C1NChunk(myBytes)));
        }
    }
}

