/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import water.persist.PersistHdfs;
import water.persist.S3ClientFactory;
import water.util.ReflectionUtils;

public class S3AClientFactory
implements S3ClientFactory {
    public static final String S3A_FACTORY_PROTOTYPE_URI = System.getProperty("sys.ai.h2o.persist.s3a.factoryPrototypeUri", "s3a://www.h2o.ai/");

    @Override
    public <T> T newClientInstance() {
        try {
            FileSystem fs = FileSystem.get((URI)URI.create(S3A_FACTORY_PROTOTYPE_URI), (Configuration)PersistHdfs.CONF);
            if (fs instanceof S3AFileSystem) {
                return ReflectionUtils.getFieldValue(fs, "s3");
            }
            throw new IllegalStateException("File system corresponding to schema s3a is not an instance of S3AFileSystem, it is " + (fs != null ? fs.getClass().getName() : "undefined") + ".");
        }
        catch (IOException e2) {
            throw new RuntimeException();
        }
    }
}

