/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import water.DKV;
import water.fvec.Vec;
import water.persist.VecDataInputStream;

public class VecFileSystem
extends FileSystem {
    private static final String KEY_PROP = "fs.hex.vec.key";
    public static Path VEC_PATH = new Path("hex:/vec");
    private Vec _v;

    public void initialize(URI name, Configuration conf) throws IOException {
        String keyStr = conf.get(KEY_PROP);
        if (keyStr == null) {
            throw new IllegalArgumentException("Configuration needs to a reference to a Vec (set property 'fs.hex.vec.key').");
        }
        this._v = (Vec)DKV.getGet(keyStr);
        super.initialize(name, conf);
    }

    public FileStatus getFileStatus(Path p2) throws IOException {
        if (VEC_PATH.equals((Object)p2)) {
            return new FileStatus(this._v.length(), false, 1, this._v.length() / (long)this._v.nChunks(), 0L, VEC_PATH);
        }
        throw new FileNotFoundException("File does not exist: " + p2);
    }

    public URI getUri() {
        return URI.create("hex:/");
    }

    public FSDataInputStream open(Path f2, int bufferSize) throws IOException {
        if (!f2.equals((Object)VEC_PATH)) {
            throw new IllegalArgumentException("Invalid path specified, expected " + VEC_PATH);
        }
        return new FSDataInputStream((InputStream)new VecDataInputStream(this._v));
    }

    public FSDataOutputStream create(Path f2, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("This is a virtual file system backed by a single Vec, 'create' not supported!");
    }

    public FSDataOutputStream append(Path f2, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("This is a virtual file system backed by a single Vec, 'append' not supported!");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException("This is a virtual file system backed by a single Vec, 'rename' not supported!");
    }

    public boolean delete(Path f2, boolean recursive) throws IOException {
        throw new UnsupportedOperationException("This is a virtual file system backed by a single Vec, 'delete' not supported!");
    }

    public FileStatus[] listStatus(Path f2) throws IOException {
        if (VEC_PATH.equals((Object)f2)) {
            return new FileStatus[]{this.getFileStatus(f2)};
        }
        return new FileStatus[0];
    }

    public boolean mkdirs(Path f2, FsPermission permission) throws IOException {
        throw new UnsupportedOperationException("This is a virtual file system backed by a single Vec, 'mkdirs' not supported!");
    }

    public void setWorkingDirectory(Path newDir) {
    }

    public Path getWorkingDirectory() {
        return null;
    }

    public static Configuration makeConfiguration(Vec v2) {
        Configuration conf = new Configuration(false);
        conf.setBoolean("fs.hex.impl.disable.cache", true);
        conf.setClass("fs.hex.impl", VecFileSystem.class, FileSystem.class);
        conf.set(KEY_PROP, v2._key.toString());
        return conf;
    }
}

