/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.H2O;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.rapids.transforms.Transform;

public class Assembly
extends Keyed<Assembly> {
    private Transform[] _steps;

    public Assembly(Key key, Transform[] steps) {
        super(key);
        this._steps = steps;
    }

    public String[] names() {
        String[] names = new String[this._steps.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = this._steps[i2].name();
        }
        return names;
    }

    public Transform[] steps() {
        return this._steps;
    }

    public Frame fit(Frame f2) {
        for (Transform step : this._steps) {
            f2 = step.fitTransform(f2);
        }
        return f2;
    }

    public String toJava(String pojoName) {
        if (pojoName == null) {
            pojoName = "GeneratedMungingPojo";
        }
        StringBuilder sb = new StringBuilder("import hex.genmodel.GenMunger;\nimport hex.genmodel.easy.RowData;\n\npublic class " + pojoName + " extends GenMunger {\n  public " + pojoName + "() {\n    _steps = new Step[" + this._steps.length + "];\n");
        int i2 = 0;
        for (Transform step : this._steps) {
            sb.append("    _steps[").append(i2++).append("] = new ").append(step.name()).append("();\n");
        }
        sb.append("  }\n");
        for (Transform step : this._steps) {
            sb.append((CharSequence)step.genClass());
        }
        sb.append("}\n");
        return sb.toString();
    }

    @Override
    protected long checksum_impl() {
        throw H2O.unimpl();
    }
}

