/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.params;

import water.rapids.Env;
import water.rapids.ast.AstParameter;
import water.rapids.vals.ValNum;

public class AstConst
extends AstParameter {
    private final ValNum _v;
    private final String name;
    public static final AstConst FALSE = new AstConst("False", 0.0);
    public static final AstConst TRUE = new AstConst("True", 1.0);
    public static final AstConst NAN = new AstConst("NaN", Double.NaN);
    public static final AstConst PI = new AstConst("Pi", Math.PI);
    public static final AstConst E = new AstConst("E", Math.E);

    public AstConst() {
        this.name = null;
        this._v = null;
    }

    public AstConst(String name, double d2) {
        this.name = name;
        this._v = new ValNum(d2);
    }

    @Override
    public String str() {
        return this.name;
    }

    @Override
    public ValNum exec(Env env) {
        return this._v;
    }
}

