/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.advmath;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import water.AutoBuffer;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMapLong;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.ArrayUtils;

public class AstTable
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"X", "Y", "dense"};
    }

    @Override
    public int nargs() {
        return -1;
    }

    @Override
    public String str() {
        return "table";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr1 = stk.track(asts[1].exec(env)).getFrame();
        boolean dense = asts[asts.length - 1].exec(env).getNum() == 1.0;
        Frame fr2 = asts.length == 4 ? stk.track(asts[2].exec(env)).getFrame() : null;
        int ncols = fr1.numCols() + (fr2 == null ? 0 : fr2.numCols());
        Vec vec1 = fr1.vec(0);
        ValFrame res = this.fast_table(vec1, ncols, fr1._names[0]);
        if (res != null) {
            return res;
        }
        if (asts.length != 3 && asts.length != 4 || ncols > 2) {
            throw new IllegalArgumentException("table expects one or two columns");
        }
        Vec vec2 = fr1.numCols() == 2 ? fr1.vec(1) : (fr2 != null ? fr2.vec(0) : null);
        int sz = fr1._names.length + (fr2 != null ? fr2._names.length : 0);
        String[] colnames = new String[sz];
        int i2 = 0;
        for (String name : fr1._names) {
            colnames[i2++] = name;
        }
        if (fr2 != null) {
            for (String name : fr2._names) {
                colnames[i2++] = name;
            }
        }
        return this.slow_table(vec1, vec2, colnames, dense);
    }

    private ValFrame fast_table(Vec v1, int ncols, String colname) {
        if (ncols != 1 || !v1.isInt()) {
            return null;
        }
        long spanl = (long)v1.max() - (long)v1.min() + 1L;
        if (spanl > 1000000L) {
            return null;
        }
        FastCnt fastCnt = (FastCnt)new FastCnt((long)v1.min(), (int)spanl).doAll(v1);
        final long[] cnts = fastCnt._cnts;
        final long minVal = fastCnt._min;
        Vec dataLayoutVec = Vec.makeCon(0L, (long)cnts.length);
        Frame fr = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk nc0, NewChunk nc1) {
                Chunk c2 = cs[0];
                for (int i2 = 0; i2 < c2._len; ++i2) {
                    int idx = (int)((long)i2 + c2.start());
                    if (cnts[idx] <= 0L) continue;
                    nc0.addNum((long)idx + minVal);
                    nc1.addNum(cnts[idx]);
                }
            }
        }.doAll(new byte[]{3, 3}, dataLayoutVec)).outputFrame(new String[]{colname, "Count"}, new String[][]{v1.domain(), null});
        dataLayoutVec.remove();
        return new ValFrame(fr);
    }

    private ValFrame slow_table(Vec v1, Vec v2, String[] colnames, boolean dense) {
        if (v2 == null) {
            SlowCnt sc = (SlowCnt)new SlowCnt().doAll(v1, v1);
            double[] dcols = AstTable.collectDomain(sc._col0s);
            Frame res = new Frame(new Vec[0]);
            Vec rowlabel = Vec.makeVec(dcols, Vec.VectorGroup.VG_LEN1.addVec());
            rowlabel.setDomain(v1.domain());
            res.add(colnames[0], rowlabel);
            long[] cnts = new long[dcols.length];
            for (int col = 0; col < dcols.length; ++col) {
                long lkey = Double.doubleToRawLongBits(dcols[col]);
                NonBlockingHashMapLong<AtomicLong> colx = sc._col0s.get(lkey);
                AtomicLong al = colx.get(lkey);
                cnts[col] = al.get();
            }
            Vec vec = Vec.makeVec(cnts, null, Vec.VectorGroup.VG_LEN1.addVec());
            res.add("Counts", vec);
            return new ValFrame(res);
        }
        Frame res = new Frame(new Vec[0]);
        if (!dense) {
            SlowCnt sc = (SlowCnt)new SlowCnt().doAll(v2, v1);
            double[] dcols = AstTable.collectDomain(sc._col0s);
            NonBlockingHashMapLong rows = new NonBlockingHashMapLong();
            NonBlockingHashMapLong.IteratorLong i2 = AstTable.iter(sc._col0s);
            while (i2.hasNext()) {
                rows.putAll((Map)sc._col0s.get(i2.nextLong()));
            }
            double[] drows = AstTable.collectDomain(rows);
            Vec rowlabel = Vec.makeVec(drows, Vec.VectorGroup.VG_LEN1.addVec());
            rowlabel.setDomain(v1.domain());
            res.add(colnames[0], rowlabel);
            long[] cnts = new long[drows.length];
            for (int col = 0; col < dcols.length; ++col) {
                NonBlockingHashMapLong<AtomicLong> colx = sc._col0s.get(Double.doubleToRawLongBits(dcols[col]));
                for (int row = 0; row < drows.length; ++row) {
                    AtomicLong al = colx.get(Double.doubleToRawLongBits(drows[row]));
                    cnts[row] = al == null ? 0L : al.get();
                }
                Vec vec = Vec.makeVec(cnts, null, Vec.VectorGroup.VG_LEN1.addVec());
                res.add(v2.isCategorical() ? v2.domain()[col] : Double.toString(dcols[col]), vec);
            }
        } else {
            SlowCnt sc = (SlowCnt)new SlowCnt().doAll(v1, v2);
            double[] dcols = AstTable.collectDomain(sc._col0s);
            NonBlockingHashMapLong rows = new NonBlockingHashMapLong();
            NonBlockingHashMapLong.IteratorLong i3 = AstTable.iter(sc._col0s);
            while (i3.hasNext()) {
                rows.putAll((Map)sc._col0s.get(i3.nextLong()));
            }
            double[] drows = AstTable.collectDomain(rows);
            int x2 = 0;
            int sz = 0;
            NonBlockingHashMapLong.IteratorLong i4 = AstTable.iter(sc._col0s);
            while (i4.hasNext()) {
                sz += sc._col0s.get(i4.nextLong()).size();
            }
            long[] cnts = new long[sz];
            double[] left_categ = new double[sz];
            double[] right_categ = new double[sz];
            for (double dcol : dcols) {
                NonBlockingHashMapLong<AtomicLong> colx = sc._col0s.get(Double.doubleToRawLongBits(dcol));
                for (double drow : drows) {
                    AtomicLong al = colx.get(Double.doubleToRawLongBits(drow));
                    if (al == null) continue;
                    left_categ[x2] = dcol;
                    right_categ[x2] = drow;
                    cnts[x2] = al.get();
                    ++x2;
                }
            }
            Vec vec = Vec.makeVec(left_categ, Vec.VectorGroup.VG_LEN1.addVec());
            if (v1.isCategorical()) {
                vec.setDomain(v1.domain());
            }
            res.add(colnames[0], vec);
            vec = Vec.makeVec(right_categ, Vec.VectorGroup.VG_LEN1.addVec());
            if (v2.isCategorical()) {
                vec.setDomain(v2.domain());
            }
            res.add(colnames[1], vec);
            vec = Vec.makeVec(cnts, null, Vec.VectorGroup.VG_LEN1.addVec());
            res.add("Counts", vec);
        }
        return new ValFrame(res);
    }

    private static double[] collectDomain(NonBlockingHashMapLong ls) {
        int sz = ls.size();
        double[] ds = new double[sz];
        int x2 = 0;
        NonBlockingHashMapLong.IteratorLong i2 = AstTable.iter(ls);
        while (i2.hasNext()) {
            ds[x2++] = Double.longBitsToDouble(i2.nextLong());
        }
        Arrays.sort(ds);
        return ds;
    }

    private static NonBlockingHashMapLong.IteratorLong iter(NonBlockingHashMapLong nbhml) {
        return (NonBlockingHashMapLong.IteratorLong)nbhml.keySet().iterator();
    }

    private static class SlowCnt
    extends MRTask<SlowCnt> {
        transient NonBlockingHashMapLong<NonBlockingHashMapLong<AtomicLong>> _col0s;

        private SlowCnt() {
        }

        @Override
        public void setupLocal() {
            this._col0s = new NonBlockingHashMapLong();
        }

        @Override
        public void map(Chunk c0, Chunk c1) {
            for (int i2 = 0; i2 < c0._len; ++i2) {
                AtomicLong old;
                AtomicLong cnt;
                NonBlockingHashMapLong<AtomicLong> old2;
                double d0 = c0.atd(i2);
                if (Double.isNaN(d0)) continue;
                long l0 = Double.doubleToRawLongBits(d0);
                double d1 = c1.atd(i2);
                if (Double.isNaN(d1)) continue;
                long l1 = Double.doubleToRawLongBits(d1);
                NonBlockingHashMapLong<AtomicLong> col1s = this._col0s.get(l0);
                if (col1s == null && (old2 = this._col0s.putIfAbsent(l0, col1s = new NonBlockingHashMapLong())) != null) {
                    col1s = old2;
                }
                if ((cnt = col1s.get(l1)) == null && (old = col1s.putIfAbsent(l1, cnt = new AtomicLong())) != null) {
                    cnt = old;
                }
                cnt.incrementAndGet();
            }
        }

        @Override
        public void reduce(SlowCnt sc) {
            if (this._col0s == sc._col0s) {
                return;
            }
            throw H2O.unimpl();
        }

        public final AutoBuffer write_impl(AutoBuffer ab) {
            if (this._col0s == null) {
                return ab.put8(0L);
            }
            ab.put8(this._col0s.size());
            for (long col0 : this._col0s.keySetLong()) {
                ab.put8(col0);
                NonBlockingHashMapLong<AtomicLong> col1s = this._col0s.get(col0);
                ab.put8(col1s.size());
                for (long col1 : col1s.keySetLong()) {
                    ab.put8(col1);
                    ab.put8(col1s.get(col1).get());
                }
            }
            return ab;
        }

        public final SlowCnt read_impl(AutoBuffer ab) {
            long len0 = ab.get8();
            if (len0 == 0L) {
                return this;
            }
            this._col0s = new NonBlockingHashMapLong();
            for (long i2 = 0L; i2 < len0; ++i2) {
                NonBlockingHashMapLong<AtomicLong> col1s = new NonBlockingHashMapLong<AtomicLong>();
                this._col0s.put(ab.get8(), col1s);
                long len1 = ab.get8();
                for (long j2 = 0L; j2 < len1; ++j2) {
                    col1s.put(ab.get8(), new AtomicLong(ab.get8()));
                }
            }
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            NonBlockingHashMapLong.IteratorLong i2 = AstTable.iter(this._col0s);
            while (i2.hasNext()) {
                long l2 = i2.nextLong();
                double d2 = Double.longBitsToDouble(l2);
                sb.append(d2).append(": {");
                NonBlockingHashMapLong<AtomicLong> col1s = this._col0s.get(l2);
                NonBlockingHashMapLong.IteratorLong j2 = AstTable.iter(col1s);
                while (j2.hasNext()) {
                    long l22 = j2.nextLong();
                    double d22 = Double.longBitsToDouble(l22);
                    AtomicLong al = col1s.get(l22);
                    sb.append(d22).append(": ").append(al.get()).append(", ");
                }
                sb.append("}\n");
            }
            return sb.toString();
        }
    }

    private static class FastCnt
    extends MRTask<FastCnt> {
        final long _min;
        final int _span;
        long[] _cnts;

        FastCnt(long min2, int span) {
            this._min = min2;
            this._span = span;
        }

        @Override
        public void map(Chunk c2) {
            this._cnts = new long[this._span];
            for (int i2 = 0; i2 < c2._len; ++i2) {
                if (c2.isNA(i2)) continue;
                int n2 = (int)(c2.at8(i2) - this._min);
                this._cnts[n2] = this._cnts[n2] + 1L;
            }
        }

        @Override
        public void reduce(FastCnt fc) {
            ArrayUtils.add(this._cnts, fc._cnts);
        }
    }
}

