/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.advmath;

import java.util.Arrays;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValNum;
import water.util.ArrayUtils;

public class AstVariance
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "x", "y", "use", "symmetric"};
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "var";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Mode mode;
        Frame frx = stk.track(asts[1].exec(env)).getFrame();
        Frame fry = stk.track(asts[2].exec(env)).getFrame();
        if (frx.numRows() != fry.numRows()) {
            throw new IllegalArgumentException("Frames must have the same number of rows, found " + frx.numRows() + " and " + fry.numRows());
        }
        String use = stk.track(asts[3].exec(env)).getStr();
        boolean symmetric = asts[4].exec(env).getNum() == 1.0;
        switch (use) {
            case "everything": {
                mode = Mode.Everything;
                break;
            }
            case "all.obs": {
                mode = Mode.AllObs;
                break;
            }
            case "complete.obs": {
                mode = Mode.CompleteObs;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown use mode: " + use);
            }
        }
        return fry.numRows() == 1L ? this.scalar(frx, fry, mode) : this.array(frx, fry, mode, symmetric);
    }

    private ValNum scalar(Frame frx, Frame fry, Mode mode) {
        double yval;
        double xval;
        if (frx.numCols() != fry.numCols()) {
            throw new IllegalArgumentException("Single rows must have the same number of columns, found " + frx.numCols() + " and " + fry.numCols());
        }
        Vec[] vecxs = frx.vecs();
        Vec[] vecys = fry.vecs();
        double xmean = 0.0;
        double ymean = 0.0;
        double ncols = frx.numCols();
        double NACount = 0.0;
        double ss = 0.0;
        int r2 = 0;
        while ((double)r2 < ncols) {
            xval = vecxs[r2].at(0L);
            yval = vecys[r2].at(0L);
            if (Double.isNaN(xval) || Double.isNaN(yval)) {
                NACount += 1.0;
            } else {
                xmean += xval;
                ymean += yval;
            }
            ++r2;
        }
        xmean /= ncols - NACount;
        ymean /= ncols - NACount;
        if (NACount != 0.0) {
            if (mode.equals((Object)Mode.AllObs)) {
                throw new IllegalArgumentException("Mode is 'all.obs' but NAs are present");
            }
            if (mode.equals((Object)Mode.Everything)) {
                return new ValNum(Double.NaN);
            }
        }
        r2 = 0;
        while ((double)r2 < ncols) {
            xval = vecxs[r2].at(0L);
            yval = vecys[r2].at(0L);
            if (!Double.isNaN(xval) && !Double.isNaN(yval)) {
                ss += (vecxs[r2].at(0L) - xmean) * (vecys[r2].at(0L) - ymean);
            }
            ++r2;
        }
        return new ValNum(ss / (ncols - NACount - 1.0));
    }

    private Val array(Frame frx, Frame fry, Mode mode, boolean symmetric) {
        Vec[] vecxs = frx.vecs();
        int ncolx = vecxs.length;
        Vec[] vecys = fry.vecs();
        int ncoly = vecys.length;
        if (mode.equals((Object)Mode.Everything) || mode.equals((Object)Mode.AllObs)) {
            if (mode.equals((Object)Mode.AllObs)) {
                for (Vec v2 : vecxs) {
                    if (v2.naCnt() == 0L) continue;
                    throw new IllegalArgumentException("Mode is 'all.obs' but NAs are present");
                }
                if (!symmetric) {
                    for (Vec v2 : vecys) {
                        if (v2.naCnt() == 0L) continue;
                        throw new IllegalArgumentException("Mode is 'all.obs' but NAs are present");
                    }
                }
            }
            CoVarTaskEverything[] cvs = new CoVarTaskEverything[ncoly];
            double[] xmeans = new double[ncolx];
            for (int x2 = 0; x2 < ncoly; ++x2) {
                xmeans[x2] = vecxs[x2].mean();
            }
            if (symmetric) {
                int y2;
                if (ncoly == 1) {
                    return new ValNum(vecys[0].naCnt() == 0L ? vecys[0].sigma() * vecys[0].sigma() : Double.NaN);
                }
                int[] idx = new int[ncoly];
                for (int y3 = 1; y3 < ncoly; ++y3) {
                    idx[y3] = y3;
                }
                int[] first_index = new int[]{0};
                for (int y4 = 0; y4 < ncoly - 1; ++y4) {
                    idx = ArrayUtils.removeIds(idx, first_index);
                    Frame reduced_fr = new Frame(frx.vecs(idx));
                    cvs[y4] = (CoVarTaskEverything)new CoVarTaskEverything(vecys[y4].mean(), xmeans).dfork(new Frame(vecys[y4]).add(reduced_fr));
                }
                double[][] res_array = new double[ncoly][ncoly];
                for (y2 = 0; y2 < ncoly; ++y2) {
                    res_array[y2][y2] = vecys[y2].naCnt() == 0L ? vecys[y2].sigma() * vecys[y2].sigma() : Double.NaN;
                }
                for (y2 = 0; y2 < ncoly - 1; ++y2) {
                    System.arraycopy(ArrayUtils.div(((CoVarTaskEverything)cvs[y2].getResult())._covs, (double)(fry.numRows() - 1L)), 0, res_array[y2], y2 + 1, ncoly - y2 - 1);
                }
                for (y2 = 0; y2 < ncoly - 1; ++y2) {
                    for (int x3 = y2 + 1; x3 < ncoly; ++x3) {
                        res_array[x3][y2] = res_array[y2][x3];
                    }
                }
                Vec[] res = new Vec[ncoly];
                Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(ncoly);
                for (int y5 = 0; y5 < ncoly; ++y5) {
                    res[y5] = Vec.makeVec(res_array[y5], keys[y5]);
                }
                return new ValFrame(new Frame(fry._names, res));
            }
            for (int y6 = 0; y6 < ncoly; ++y6) {
                cvs[y6] = (CoVarTaskEverything)new CoVarTaskEverything(vecys[y6].mean(), xmeans).dfork(new Frame(vecys[y6]).add(frx));
            }
            if (ncolx == 1 && ncoly == 1) {
                return new ValNum(((CoVarTaskEverything)cvs[0].getResult())._covs[0] / (double)(fry.numRows() - 1L));
            }
            Vec[] res = new Vec[ncoly];
            Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(ncoly);
            for (int y7 = 0; y7 < ncoly; ++y7) {
                res[y7] = Vec.makeVec(ArrayUtils.div(((CoVarTaskEverything)cvs[y7].getResult())._covs, (double)(fry.numRows() - 1L)), keys[y7]);
            }
            return new ValFrame(new Frame(fry._names, res));
        }
        if (symmetric) {
            int y8;
            if (ncoly == 1) {
                return new ValNum(vecys[0].sigma() * vecys[0].sigma());
            }
            CoVarTaskCompleteObsMeanSym taskCompleteObsMeanSym = (CoVarTaskCompleteObsMeanSym)new CoVarTaskCompleteObsMeanSym().doAll(fry);
            long NACount = taskCompleteObsMeanSym._NACount;
            double[] ymeans = ArrayUtils.div(taskCompleteObsMeanSym._ysum, (double)(fry.numRows() - NACount));
            CoVarTaskCompleteObsSym cvs = (CoVarTaskCompleteObsSym)new CoVarTaskCompleteObsSym(ymeans).doAll(new Frame(fry));
            double[][] res_array = new double[ncoly][ncoly];
            for (y8 = 0; y8 < ncoly; ++y8) {
                System.arraycopy(ArrayUtils.div(cvs._covs[y8], (double)(fry.numRows() - 1L - NACount)), y8, res_array[y8], y8, ncoly - y8);
            }
            for (y8 = 0; y8 < ncoly - 1; ++y8) {
                for (int x4 = y8 + 1; x4 < ncoly; ++x4) {
                    res_array[x4][y8] = res_array[y8][x4];
                }
            }
            Vec[] res = new Vec[ncoly];
            Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(ncoly);
            for (int y9 = 0; y9 < ncoly; ++y9) {
                res[y9] = Vec.makeVec(res_array[y9], keys[y9]);
            }
            return new ValFrame(new Frame(fry._names, res));
        }
        CoVarTaskCompleteObsMean taskCompleteObsMean = (CoVarTaskCompleteObsMean)new CoVarTaskCompleteObsMean(ncoly, ncolx).doAll(new Frame(fry).add(frx));
        long NACount = taskCompleteObsMean._NACount;
        double[] ymeans = ArrayUtils.div(taskCompleteObsMean._ysum, (double)(fry.numRows() - NACount));
        double[] xmeans = ArrayUtils.div(taskCompleteObsMean._xsum, (double)(fry.numRows() - NACount));
        CoVarTaskCompleteObs cvs = (CoVarTaskCompleteObs)new CoVarTaskCompleteObs(ymeans, xmeans).doAll(new Frame(fry).add(frx));
        if (ncolx == 1 && ncoly == 1) {
            return new ValNum(cvs._covs[0][0] / (double)(fry.numRows() - 1L - NACount));
        }
        Vec[] res = new Vec[ncoly];
        Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(ncoly);
        for (int y10 = 0; y10 < ncoly; ++y10) {
            res[y10] = Vec.makeVec(ArrayUtils.div(cvs._covs[y10], (double)(fry.numRows() - 1L - NACount)), keys[y10]);
        }
        return new ValFrame(new Frame(fry._names, res));
    }

    public static double getVar(Vec v2) {
        return v2.naCnt() == 0L ? v2.sigma() * v2.sigma() : Double.NaN;
    }

    private static class CoVarTaskCompleteObsSym
    extends MRTask<CoVarTaskCompleteObsSym> {
        double[][] _covs;
        final double[] _ymeans;

        CoVarTaskCompleteObsSym(double[] ymeans) {
            this._ymeans = ymeans;
        }

        @Override
        public void map(Chunk[] cs) {
            int ncoly = this._ymeans.length;
            double[] yvals = new double[ncoly];
            this._covs = new double[ncoly][ncoly];
            int len = cs[0]._len;
            for (int row = 0; row < len; ++row) {
                double yval;
                int y2;
                boolean add = true;
                Arrays.fill(yvals, 0.0);
                for (y2 = 0; y2 < ncoly; ++y2) {
                    Chunk cy = cs[y2];
                    yval = cy.atd(row);
                    if (Double.isNaN(yval)) {
                        add = false;
                        break;
                    }
                    yvals[y2] = yval;
                }
                if (!add) continue;
                for (y2 = 0; y2 < ncoly; ++y2) {
                    double[] _covs_y = this._covs[y2];
                    yval = yvals[y2];
                    double ymean = this._ymeans[y2];
                    for (int x2 = y2; x2 < ncoly; ++x2) {
                        int n2 = x2;
                        _covs_y[n2] = _covs_y[n2] + (yvals[x2] - this._ymeans[x2]) * (yval - ymean);
                    }
                }
            }
        }

        @Override
        public void reduce(CoVarTaskCompleteObsSym cvt) {
            ArrayUtils.add(this._covs, cvt._covs);
        }
    }

    private static class CoVarTaskCompleteObsMeanSym
    extends MRTask<CoVarTaskCompleteObsMeanSym> {
        double[] _ysum;
        long _NACount;

        private CoVarTaskCompleteObsMeanSym() {
        }

        @Override
        public void map(Chunk[] cs) {
            int ncoly = cs.length;
            this._ysum = new double[ncoly];
            double[] yvals = new double[ncoly];
            int len = cs[0]._len;
            for (int row = 0; row < len; ++row) {
                boolean add = true;
                Arrays.fill(yvals, 0.0);
                for (int y2 = 0; y2 < ncoly; ++y2) {
                    Chunk cy = cs[y2];
                    double yval = cy.atd(row);
                    if (Double.isNaN(yval)) {
                        ++this._NACount;
                        add = false;
                        break;
                    }
                    yvals[y2] = yval;
                }
                if (!add) continue;
                ArrayUtils.add(this._ysum, yvals);
            }
        }

        @Override
        public void reduce(CoVarTaskCompleteObsMeanSym cvt) {
            ArrayUtils.add(this._ysum, cvt._ysum);
            this._NACount += cvt._NACount;
        }
    }

    private static class CoVarTaskCompleteObs
    extends MRTask<CoVarTaskCompleteObs> {
        double[][] _covs;
        final double[] _xmeans;
        final double[] _ymeans;

        CoVarTaskCompleteObs(double[] ymeans, double[] xmeans) {
            this._ymeans = ymeans;
            this._xmeans = xmeans;
        }

        @Override
        public void map(Chunk[] cs) {
            int ncolx = this._xmeans.length;
            int ncoly = this._ymeans.length;
            double[] xvals = new double[ncolx];
            double[] yvals = new double[ncoly];
            this._covs = new double[ncoly][ncolx];
            int len = cs[0]._len;
            for (int row = 0; row < len; ++row) {
                double yval;
                int y2;
                boolean add = true;
                Arrays.fill(xvals, 0.0);
                Arrays.fill(yvals, 0.0);
                for (y2 = 0; y2 < ncoly; ++y2) {
                    Chunk cy = cs[y2];
                    yval = cy.atd(row);
                    if (Double.isNaN(yval)) {
                        add = false;
                        break;
                    }
                    yvals[y2] = yval;
                }
                if (add) {
                    for (int x2 = 0; x2 < ncolx; ++x2) {
                        Chunk cx = cs[x2 + ncoly];
                        double xval = cx.atd(row);
                        if (Double.isNaN(xval)) {
                            add = false;
                            break;
                        }
                        xvals[x2] = xval;
                    }
                }
                if (!add) continue;
                for (y2 = 0; y2 < ncoly; ++y2) {
                    double[] _covs_y = this._covs[y2];
                    yval = yvals[y2];
                    double ymean = this._ymeans[y2];
                    for (int x3 = 0; x3 < ncolx; ++x3) {
                        int n2 = x3;
                        _covs_y[n2] = _covs_y[n2] + (xvals[x3] - this._xmeans[x3]) * (yval - ymean);
                    }
                }
            }
        }

        @Override
        public void reduce(CoVarTaskCompleteObs cvt) {
            ArrayUtils.add(this._covs, cvt._covs);
        }
    }

    private static class CoVarTaskCompleteObsMean
    extends MRTask<CoVarTaskCompleteObsMean> {
        double[] _xsum;
        double[] _ysum;
        long _NACount;
        int _ncolx;
        int _ncoly;

        CoVarTaskCompleteObsMean(int ncoly, int ncolx) {
            this._ncolx = ncolx;
            this._ncoly = ncoly;
        }

        @Override
        public void map(Chunk[] cs) {
            this._xsum = new double[this._ncolx];
            this._ysum = new double[this._ncoly];
            double[] xvals = new double[this._ncolx];
            double[] yvals = new double[this._ncoly];
            int len = cs[0]._len;
            for (int row = 0; row < len; ++row) {
                boolean add = true;
                Arrays.fill(xvals, 0.0);
                Arrays.fill(yvals, 0.0);
                for (int y2 = 0; y2 < this._ncoly; ++y2) {
                    Chunk cy = cs[y2];
                    double yval = cy.atd(row);
                    if (Double.isNaN(yval)) {
                        ++this._NACount;
                        add = false;
                        break;
                    }
                    yvals[y2] = yval;
                }
                if (add) {
                    for (int x2 = 0; x2 < this._ncolx; ++x2) {
                        Chunk cx = cs[x2 + this._ncoly];
                        double xval = cx.atd(row);
                        if (Double.isNaN(xval)) {
                            ++this._NACount;
                            add = false;
                            break;
                        }
                        xvals[x2] = xval;
                    }
                }
                if (!add) continue;
                ArrayUtils.add(this._xsum, xvals);
                ArrayUtils.add(this._ysum, yvals);
            }
        }

        @Override
        public void reduce(CoVarTaskCompleteObsMean cvt) {
            ArrayUtils.add(this._xsum, cvt._xsum);
            ArrayUtils.add(this._ysum, cvt._ysum);
            this._NACount += cvt._NACount;
        }
    }

    private static class CoVarTaskEverything
    extends MRTask<CoVarTaskEverything> {
        double[] _covs;
        final double[] _xmeans;
        final double _ymean;

        CoVarTaskEverything(double ymean, double[] xmeans) {
            this._ymean = ymean;
            this._xmeans = xmeans;
        }

        @Override
        public void map(Chunk[] cs) {
            int ncolsx = cs.length - 1;
            Chunk cy = cs[0];
            int len = cy._len;
            this._covs = new double[ncolsx];
            for (int x2 = 0; x2 < ncolsx; ++x2) {
                double sum = 0.0;
                Chunk cx = cs[x2 + 1];
                double xmean = this._xmeans[x2];
                for (int row = 0; row < len; ++row) {
                    sum += (cx.atd(row) - xmean) * (cy.atd(row) - this._ymean);
                }
                this._covs[x2] = sum;
            }
        }

        @Override
        public void reduce(CoVarTaskEverything cvt) {
            ArrayUtils.add(this._covs, cvt._covs);
        }
    }

    private static enum Mode {
        Everything,
        AllObs,
        CompleteObs;

    }
}

