/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.filters.dropduplicates;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Val;

public class ColumnIndicesParser {
    public static int[] parseAndCheckComparedColumnIndices(Frame deduplicatedFrame, Val comparedColumns) throws IllegalArgumentException {
        int[] columnIndices;
        if (comparedColumns.isStr()) {
            String columnName = comparedColumns.getStr();
            int columnIndex = deduplicatedFrame.find(columnName);
            if (columnIndex == -1) {
                throw new IllegalArgumentException(String.format("Unknown column name: '%s'", columnName));
            }
            columnIndices = new int[]{columnIndex};
        } else if (comparedColumns.isStrs()) {
            String[] columnNames = comparedColumns.getStrs();
            columnIndices = new int[columnNames.length];
            for (int i2 = 0; i2 < columnNames.length; ++i2) {
                String columnName = columnNames[i2];
                int columnIndex = deduplicatedFrame.find(columnName);
                if (columnIndex == -1) {
                    throw new IllegalArgumentException(String.format("Unknown column name: '%s'", columnName));
                }
                if (ColumnIndicesParser.isUnsupportedVecType(deduplicatedFrame.types()[columnIndex])) {
                    throw new IllegalArgumentException(String.format("Column '%s' is of unsupported type %s for row de-duplication.", columnName, Vec.TYPE_STR[deduplicatedFrame.types()[columnIndex]]));
                }
                columnIndices[i2] = columnIndex;
            }
        } else if (comparedColumns.isNums()) {
            double[] columnRangeDouble = comparedColumns.getNums();
            columnIndices = new int[columnRangeDouble.length];
            for (int i3 = 0; i3 < columnRangeDouble.length; ++i3) {
                columnIndices[i3] = (int)columnRangeDouble[i3];
                if (columnIndices[i3] < 0 || columnIndices[i3] > deduplicatedFrame.numCols() - 1) {
                    throw new IllegalArgumentException(String.format("No such column index: '%d', frame has %d columns,maximum index is %d. ", columnIndices[i3], deduplicatedFrame.numCols(), deduplicatedFrame.numCols() - 1));
                }
                if (!ColumnIndicesParser.isUnsupportedVecType(deduplicatedFrame.types()[columnIndices[i3]])) continue;
                throw new IllegalArgumentException(String.format("Column '%s' is of unsupported type %s for row de-duplication.", deduplicatedFrame.name(columnIndices[i3]), Vec.TYPE_STR[deduplicatedFrame.types()[columnIndices[i3]]]));
            }
        } else {
            throw new IllegalArgumentException(String.format("Column range for deduplication must either be a set of columns, or a column range. Given type: %s", comparedColumns.type()));
        }
        return columnIndices;
    }

    private static boolean isUnsupportedVecType(byte vecType) {
        return vecType == 2 || vecType == 0 || vecType == 1;
    }
}

