/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import water.H2O;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstCBind
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"..."};
    }

    @Override
    public int nargs() {
        return -1;
    }

    @Override
    public String str() {
        return "cbind";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Val[] vals = new Val[asts.length];
        Vec vec = null;
        for (int i2 = 1; i2 < asts.length; ++i2) {
            Vec anyvec;
            vals[i2] = stk.track(asts[i2].exec(env));
            if (!vals[i2].isFrame() || (anyvec = vals[i2].getFrame().anyVec()) == null) continue;
            if (vec == null) {
                vec = anyvec;
                continue;
            }
            if (vec.length() == anyvec.length()) continue;
            throw new IllegalArgumentException("cbind frames must have all the same rows, found " + vec.length() + " and " + anyvec.length() + " rows.");
        }
        boolean clean = false;
        if (vec == null) {
            vec = Vec.makeZero(1L);
            clean = true;
        }
        Frame fr = new Frame(new Vec[0]);
        block7: for (int i3 = 1; i3 < asts.length; ++i3) {
            switch (vals[i3].type()) {
                case 5: {
                    fr.add(vals[i3].getFrame().names(), fr.makeCompatible(vals[i3].getFrame()));
                    continue block7;
                }
                case 7: {
                    throw H2O.unimpl();
                }
                case 3: {
                    throw H2O.unimpl();
                }
                case 1: {
                    double d2 = vals[i3].getNum();
                    fr.add(Double.toString(d2), vec.makeCon(d2));
                    continue block7;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
        }
        if (clean) {
            vec.remove();
        }
        return new ValFrame(fr);
    }
}

