/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstParameter;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNum;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValRow;

public class AstColPySlice
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "cols"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "cols_py";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Val v2 = stk.track(asts[1].exec(env));
        AstParameter colList = (AstParameter)asts[2];
        if (v2 instanceof ValRow) {
            ValRow vv = (ValRow)v2;
            return vv.slice(colList.columns(vv.getNames()));
        }
        Frame fr = v2.getFrame();
        int[] cols = colList.columns(fr.names());
        Frame fr2 = new Frame(new Vec[0]);
        if (cols.length == 0) {
            return new ValFrame(fr2);
        }
        if (cols[0] < 0) {
            int i2 = 0;
            while (i2 < cols.length) {
                int n2 = i2++;
                cols[n2] = cols[n2] + fr.numCols();
            }
        }
        if (asts[2] instanceof AstNum && (cols[0] < 0 || cols[0] >= fr.numCols())) {
            throw new IllegalArgumentException("Column must be an integer from 0 to " + (fr.numCols() - 1));
        }
        for (int col : cols) {
            if (col < 0 || col >= fr.numCols()) continue;
            fr2.add(fr.names()[col], fr.vecs()[col]);
        }
        return new ValFrame(fr2);
    }
}

