/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.Arrays;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstFillNA
extends AstPrimitive {
    private static final String METHOD_BACKWARD = "backward";

    @Override
    public String[] args() {
        return new String[]{"ary", "method", "axis", "limit"};
    }

    @Override
    public String str() {
        return "h2o.fillna";
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        String method = asts[2].exec(env).getStr();
        if (!Arrays.asList("forward", METHOD_BACKWARD).contains(method.toLowerCase())) {
            throw new IllegalArgumentException("Method must be forward or backward");
        }
        int axis = (int)asts[3].exec(env).getNum();
        if (!Arrays.asList(0, 1).contains(axis)) {
            throw new IllegalArgumentException("Axis must be 0 for columnar 1 for row");
        }
        int limit = (int)asts[4].exec(env).getNum();
        assert (limit >= 0) : "The maxlen/limit parameter should be >= 0.";
        if (limit == 0) {
            return new ValFrame(fr.deepCopy(Key.make().toString()));
        }
        Frame res = axis == 0 ? (METHOD_BACKWARD.equalsIgnoreCase(method.trim()) ? ((FillBackwardTaskCol)new FillBackwardTaskCol(limit, fr.anyVec().nChunks()).doAll(fr.numCols(), (byte)3, fr)).outputFrame() : ((FillForwardTaskCol)new FillForwardTaskCol(limit).doAll(fr.numCols(), (byte)3, fr)).outputFrame()) : (METHOD_BACKWARD.equalsIgnoreCase(method.trim()) ? ((FillBackwardTaskRow)new FillBackwardTaskRow(limit).doAll(fr.numCols(), (byte)3, fr)).outputFrame() : ((FillForwardTaskRow)new FillForwardTaskRow(limit).doAll(fr.numCols(), (byte)3, fr)).outputFrame());
        res._key = Key.make();
        return new ValFrame(res);
    }

    private static class FillBackwardTaskCol
    extends MRTask<FillBackwardTaskCol> {
        private final int _maxLen;
        private final int _lastChunkIndex;

        FillBackwardTaskCol(int maxLen, int chunksNum) {
            this._maxLen = maxLen;
            this._lastChunkIndex = chunksNum - 1;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            int lastRowIndex = cs[0]._len - 1;
            int currentCidx = cs[0].cidx();
            double[] newChunkInfo = new double[cs[0].len()];
            int chkLen = cs[0].len();
            for (int i2 = 0; i2 < cs.length; ++i2) {
                int naBlockRowStart = -1;
                int lastNonNaNRow = -1;
                int rowIndex = lastRowIndex;
                int naBlockLength = 0;
                double fillVal = Double.NaN;
                int fillLen = 0;
                while (rowIndex > -1) {
                    if (cs[i2].isNA(rowIndex)) {
                        naBlockRowStart = rowIndex--;
                        ++naBlockLength;
                        while (rowIndex > -1 && cs[i2].isNA(rowIndex)) {
                            ++naBlockLength;
                            --rowIndex;
                        }
                        if (lastNonNaNRow < 0) {
                            if (currentCidx == this._lastChunkIndex) {
                                fillLen = 0;
                            } else {
                                fillLen = this._maxLen;
                                boolean foundFillVal = false;
                                block3: for (int cIndex = currentCidx + 1; cIndex <= this._lastChunkIndex && !foundFillVal; ++cIndex) {
                                    Chunk nextChunk = cs[i2].vec().chunkForChunkIdx(cIndex);
                                    int nChunkLen = nextChunk.len();
                                    for (int rIndex = 0; rIndex < nChunkLen; ++rIndex) {
                                        if (!nextChunk.isNA(rIndex)) {
                                            fillVal = nextChunk.atd(rIndex);
                                            foundFillVal = true;
                                            continue block3;
                                        }
                                        if (--fillLen < 1) continue block3;
                                    }
                                }
                            }
                        } else {
                            fillVal = cs[i2].atd(lastNonNaNRow);
                            fillLen = this._maxLen;
                        }
                        int naRowEnd = naBlockRowStart - naBlockLength;
                        for (int naRow = naBlockRowStart; naRow > naRowEnd; --naRow) {
                            if (fillLen > 0) {
                                newChunkInfo[naRow] = fillVal;
                                --fillLen;
                                continue;
                            }
                            newChunkInfo[naRow] = Double.NaN;
                        }
                        naBlockLength = 0;
                        lastNonNaNRow = -1;
                        continue;
                    }
                    newChunkInfo[rowIndex] = cs[i2].atd(rowIndex);
                    lastNonNaNRow = rowIndex--;
                    naBlockLength = 0;
                }
                for (int rindex = 0; rindex < chkLen; ++rindex) {
                    nc[i2].addNum(newChunkInfo[rindex]);
                }
            }
        }
    }

    private static class FillForwardTaskCol
    extends MRTask<FillForwardTaskCol> {
        private final int _maxLen;

        FillForwardTaskCol(int maxLen) {
            this._maxLen = maxLen;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            for (int i2 = 0; i2 < cs.length; ++i2) {
                for (int j2 = 0; j2 < cs[i2]._len; ++j2) {
                    if (cs[i2].isNA(j2)) {
                        if (j2 < this._maxLen) {
                            int searchCount = 0;
                            Chunk searchChunk = cs[i2];
                            int searchStartIdx = j2;
                            int searchIdx = 0;
                            while (searchChunk != null && searchCount < this._maxLen && searchChunk.isNA(searchStartIdx - searchIdx)) {
                                if (searchStartIdx - searchCount == 0) {
                                    if (searchChunk.cidx() > 0) {
                                        searchChunk = searchChunk.vec().chunkForChunkIdx(searchChunk.cidx() - 1);
                                        searchStartIdx = searchChunk.len() - 1;
                                        searchIdx = 0;
                                        ++searchCount;
                                        continue;
                                    }
                                    searchChunk = null;
                                }
                                ++searchIdx;
                                ++searchCount;
                            }
                            if (searchChunk == null) {
                                nc[i2].addNA();
                                continue;
                            }
                            double fillVal = searchChunk.atd(searchStartIdx - searchIdx);
                            int fillCount = this._maxLen - searchCount;
                            fillCount = Math.min(fillCount, cs[i2]._len);
                            int maxFill = 1;
                            int k2 = 1;
                            while (cs[i2].isNA(j2 + k2)) {
                                ++k2;
                                ++maxFill;
                            }
                            if ((fillCount = Math.min(maxFill, fillCount)) < 0) {
                                nc[i2].addNA();
                            } else if (fillCount == 0) {
                                nc[i2].addNum(fillVal);
                            } else {
                                for (int f2 = 0; f2 < fillCount; ++f2) {
                                    nc[i2].addNum(fillVal);
                                }
                            }
                            fillCount = Math.max(1, fillCount);
                            j2 += fillCount - 1;
                            continue;
                        }
                        nc[i2].addNA();
                        continue;
                    }
                    if (j2 < cs[i2]._len - 1 && !cs[i2].isNA(j2) && cs[i2].isNA(j2 + 1)) {
                        int fillCount;
                        double fillVal = cs[i2].atd(j2);
                        nc[i2].addNum(fillVal);
                        ++j2;
                        for (fillCount = 0; j2 + fillCount < cs[i2]._len && fillCount < this._maxLen && cs[i2].isNA(j2 + fillCount); ++fillCount) {
                            nc[i2].addNum(fillVal);
                        }
                        j2 += fillCount - 1;
                        continue;
                    }
                    nc[i2].addNum(cs[i2].atd(j2));
                }
            }
        }
    }

    private static class FillBackwardTaskRow
    extends MRTask<FillBackwardTaskRow> {
        private final int _maxLen;

        FillBackwardTaskRow(int maxLen) {
            this._maxLen = maxLen;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            int lastCol = cs.length - 1;
            for (int i2 = 0; i2 < cs[0]._len; ++i2) {
                int fillCount = 0;
                nc[lastCol].addNum(cs[lastCol].atd(i2));
                for (int j2 = lastCol - 1; j2 >= 0; --j2) {
                    if (cs[j2].isNA(i2)) {
                        int lastNonNACol = j2 + 1;
                        if (!nc[lastNonNACol].isNA(i2) && fillCount < this._maxLen) {
                            nc[j2].addNum(nc[lastNonNACol].atd(i2));
                            ++fillCount;
                            continue;
                        }
                        nc[j2].addNA();
                        continue;
                    }
                    if (fillCount > 0) {
                        fillCount = 0;
                    }
                    nc[j2].addNum(cs[j2].atd(i2));
                }
            }
        }
    }

    private static class FillForwardTaskRow
    extends MRTask<FillForwardTaskRow> {
        private final int _maxLen;

        FillForwardTaskRow(int maxLen) {
            this._maxLen = maxLen;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            for (int i2 = 0; i2 < cs[0]._len; ++i2) {
                int fillCount = 0;
                nc[0].addNum(cs[0].atd(i2));
                for (int j2 = 1; j2 < cs.length; ++j2) {
                    if (cs[j2].isNA(i2)) {
                        if (!nc[j2 - 1].isNA(i2) && fillCount < this._maxLen) {
                            nc[j2].addNum(nc[j2 - 1].atd(i2));
                            ++fillCount;
                            continue;
                        }
                        nc[j2].addNA();
                        continue;
                    }
                    if (fillCount > 0) {
                        fillCount = 0;
                    }
                    nc[j2].addNum(cs[j2].atd(i2));
                }
            }
        }
    }
}

