/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.ArrayList;
import java.util.Iterator;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValNums;

public class AstFilterNaCols
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "fraction"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "filterNACols";
    }

    @Override
    public ValNums apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        double frac = asts[2].exec(env).getNum();
        double nrow = (double)fr.numRows() * frac;
        Vec[] vecs = fr.vecs();
        ArrayList<Double> idxs = new ArrayList<Double>();
        for (double i2 = 0.0; i2 < (double)fr.numCols(); i2 += 1.0) {
            if (!((double)vecs[(int)i2].naCnt() < nrow)) continue;
            idxs.add(i2);
        }
        double[] include_cols = new double[idxs.size()];
        int i3 = 0;
        Iterator iterator = idxs.iterator();
        while (iterator.hasNext()) {
            double d2 = (Double)iterator.next();
            include_cols[i3++] = d2;
        }
        return new ValNums(include_cols);
    }
}

