/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import water.Futures;
import water.Key;
import water.fvec.AppendableVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstLevels
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "levels";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame f2 = stk.track(asts[1].exec(env)).getFrame();
        Futures fs = new Futures();
        Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(f2.numCols());
        Vec[] vecs = new Vec[keys.length];
        int max = 0;
        for (int i2 = 0; i2 < f2.numCols(); ++i2) {
            if (!f2.vec(i2).isCategorical() || max >= f2.vec(i2).domain().length) continue;
            max = f2.vec(i2).domain().length;
        }
        int rowLayout = Vec.ESPC.rowLayout(keys[0], new long[]{0L, max});
        for (int i3 = 0; i3 < f2.numCols(); ++i3) {
            int j2;
            int numToPad;
            AppendableVec v2 = new AppendableVec(keys[i3], 3);
            NewChunk nc = new NewChunk(v2, 0);
            String[] dom = f2.vec(i3).domain();
            int n2 = numToPad = dom == null ? max : max - dom.length;
            if (dom != null) {
                for (j2 = 0; j2 < dom.length; ++j2) {
                    nc.addNum(j2);
                }
            }
            for (j2 = 0; j2 < numToPad; ++j2) {
                nc.addNA();
            }
            nc.close(0, fs);
            vecs[i3] = v2.close(rowLayout, fs);
            vecs[i3].setDomain(dom);
        }
        fs.blockForPending();
        Frame fr2 = new Frame(vecs);
        return new ValFrame(fr2);
    }
}

