/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValNum;

public class AstNLevels
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "nlevels";
    }

    @Override
    public ValNum apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() == 1) {
            Vec v2 = fr.anyVec();
            int nlevels = v2 != null && v2.isCategorical() ? v2.domain().length : 0;
            return new ValNum(nlevels);
        }
        throw new IllegalArgumentException("nlevels applies to a single column. Got: " + fr.numCols());
    }
}

