/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.CountedCompleter;
import water.DKV;
import water.H2O;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstRBind
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"..."};
    }

    @Override
    public int nargs() {
        return -1;
    }

    @Override
    public String str() {
        return "rbind";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = null;
        int nchks = 0;
        Val[] vals = new Val[asts.length];
        for (int i2 = 1; i2 < asts.length; ++i2) {
            vals[i2] = stk.track(asts[i2].exec(env));
            if (vals[i2].isFrame()) {
                fr = vals[i2].getFrame();
                nchks += fr.anyVec().nChunks();
                continue;
            }
            ++nchks;
        }
        Vec zz = null;
        if (fr == null) {
            fr = new Frame(new String[]{Frame.defaultColName(0)}, new Vec[]{zz = Vec.makeZero(0L)});
            if (asts.length == 1) {
                return new ValFrame(fr);
            }
        }
        Frame[] frs = new Frame[asts.length];
        byte[] types2 = fr.types();
        long[] espc = new long[nchks + 1];
        int coffset = 0;
        Frame[] tmp_frs = new Frame[asts.length];
        for (int i3 = 1; i3 < asts.length; ++i3) {
            Frame fr0;
            Val val = vals[i3];
            Frame frame = fr0 = val.isFrame() ? val.getFrame() : new Frame(fr._names, Vec.makeCons(val.getNum(), 1L, fr.numCols()));
            if (fr.numCols() != fr0.numCols()) {
                throw new IllegalArgumentException("rbind frames must have all the same columns, found " + fr.numCols() + " and " + fr0.numCols() + " columns.");
            }
            if (!Arrays.deepEquals(fr._names, fr0._names)) {
                throw new IllegalArgumentException("rbind frames must have all the same column names, found " + Arrays.toString(fr._names) + " and " + Arrays.toString(fr0._names));
            }
            if (!Arrays.equals(types2, fr0.types())) {
                throw new IllegalArgumentException("rbind frames must have all the same column types, found " + Arrays.toString(types2) + " and " + Arrays.toString(fr0.types()));
            }
            frs[i3] = fr0;
            long roffset = espc[coffset];
            long[] espc2 = fr0.anyVec().espc();
            for (int j2 = 1; j2 < espc2.length; ++j2) {
                espc[coffset + j2] = roffset + espc2[j2];
            }
            coffset += espc2.length - 1;
        }
        if (zz != null) {
            zz.remove();
        }
        HashMap[] dmap = new HashMap[types2.length];
        String[][] domains = new String[types2.length][];
        int[][][] cmaps = new int[types2.length][][];
        for (int k2 = 0; k2 < types2.length; ++k2) {
            Object maps;
            dmap[k2] = new HashMap();
            int c2 = 0;
            byte t2 = types2[k2];
            if (t2 == 4) {
                maps = new int[frs.length][];
                for (int i4 = 1; i4 < frs.length; ++i4) {
                    maps[i4] = new int[frs[i4].vec(k2).domain().length];
                    for (int j3 = 0; j3 < ((Object)maps[i4]).length; ++j3) {
                        String s2 = frs[i4].vec(k2).domain()[j3];
                        if (!dmap[k2].containsKey(s2)) {
                            int n2 = c2++;
                            maps[i4][j3] = n2;
                            dmap[k2].put(s2, n2);
                            continue;
                        }
                        maps[i4][j3] = (Integer)dmap[k2].get(s2);
                    }
                }
                cmaps[k2] = (int[][])maps;
            } else {
                cmaps[k2] = new int[frs.length][];
            }
            domains[k2] = c2 == 0 ? null : new String[c2];
            maps = dmap[k2].entrySet().iterator();
            while (maps.hasNext()) {
                Map.Entry e2 = (Map.Entry)maps.next();
                domains[k2][((Integer)e2.getValue()).intValue()] = (String)e2.getKey();
            }
        }
        Key<Vec>[] keys = fr.anyVec().group().addVecs(fr.numCols());
        Vec[] vecs = new Vec[fr.numCols()];
        int rowLayout = Vec.ESPC.rowLayout(keys[0], espc);
        for (int i5 = 0; i5 < vecs.length; ++i5) {
            vecs[i5] = new Vec(keys[i5], rowLayout, domains[i5], types2[i5]);
        }
        ParallelRbinds t3 = new ParallelRbinds(frs, espc, vecs, cmaps);
        H2O.submitTask(t3).join();
        for (Frame tfr : tmp_frs) {
            if (tfr == null) continue;
            tfr.delete();
        }
        return new ValFrame(new Frame(fr.names(), t3._vecs));
    }

    private static class RbindMRTask
    extends MRTask<RbindMRTask> {
        private final int[] _cmap;
        private final int _chunkOffset;
        private final Vec _v;

        RbindMRTask(H2O.H2OCountedCompleter hc2, int[] cmap, Vec v2, int offset) {
            super(hc2);
            this._cmap = cmap;
            this._v = v2;
            this._chunkOffset = offset;
        }

        @Override
        public void map(Chunk cs) {
            int idx = this._chunkOffset + cs.cidx();
            Key ckey = Vec.chunkKey(this._v._key, idx);
            if (this._cmap != null) {
                assert (!cs.hasFloat()) : "Input chunk (" + cs.getClass() + ") has float, but is expected to be categorical";
                NewChunk nc = new NewChunk(this._v, idx);
                for (int r2 = 0; r2 < cs._len; ++r2) {
                    if (cs.isNA(r2)) {
                        nc.addNA();
                        continue;
                    }
                    nc.addNum(this._cmap[(int)cs.at8(r2)], 0);
                }
                nc.close(this._fs);
            } else {
                DKV.put(ckey, cs.deepCopy(), this._fs, true);
            }
        }
    }

    private static class RbindTask
    extends H2O.H2OCountedCompleter<RbindTask> {
        final Vec[] _vecs;
        final Vec _v;
        final long[] _espc;
        int[][] _cmaps;

        RbindTask(H2O.H2OCountedCompleter cc, Vec[] vecs, Vec v2, long[] espc, int[][] cmaps) {
            super(cc);
            this._vecs = vecs;
            this._v = v2;
            this._espc = espc;
            this._cmaps = cmaps;
        }

        @Override
        public void compute2() {
            this.addToPendingCount(this._vecs.length - 1 - 1);
            int offset = 0;
            for (int i2 = 1; i2 < this._vecs.length; ++i2) {
                new RbindMRTask(this, this._cmaps[i2], this._v, offset).dfork(this._vecs[i2]);
                offset += this._vecs[i2].nChunks();
            }
        }

        @Override
        public void onCompletion(CountedCompleter cc) {
            DKV.put(this._v);
        }
    }

    private static class ParallelRbinds
    extends H2O.H2OCountedCompleter {
        private final AtomicInteger _ctr;
        private static int MAXP = 100;
        private Frame[] _frs;
        private int[][][] _cmaps;
        private long[] _espc;
        private Vec[] _vecs;

        ParallelRbinds(Frame[] frs, long[] espc, Vec[] vecs, int[][][] cmaps) {
            this._frs = frs;
            this._espc = espc;
            this._vecs = vecs;
            this._cmaps = cmaps;
            this._ctr = new AtomicInteger(MAXP - 1);
        }

        @Override
        public void compute2() {
            int ncols = this._frs[1].numCols();
            this.addToPendingCount(ncols - 1);
            for (int i2 = 0; i2 < Math.min(MAXP, ncols); ++i2) {
                this.forkVecTask(i2);
            }
        }

        private void forkVecTask(int colnum) {
            Vec[] vecs = new Vec[this._frs.length];
            for (int i2 = 1; i2 < this._frs.length; ++i2) {
                vecs[i2] = this._frs[i2].vec(colnum);
            }
            new RbindTask(new Callback(), vecs, this._vecs[colnum], this._espc, this._cmaps[colnum]).fork();
        }

        private class Callback
        extends H2O.H2OCallback {
            public Callback() {
                super(ParallelRbinds.this);
            }

            public void callback(H2O.H2OCountedCompleter h2OCountedCompleter) {
                int i2 = ParallelRbinds.this._ctr.incrementAndGet();
                if (i2 < ParallelRbinds.this._vecs.length) {
                    ParallelRbinds.this.forkVecTask(i2);
                }
            }
        }
    }
}

