/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import hex.Model;
import water.DKV;
import water.Key;
import water.fvec.Frame;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValNum;

public class AstRename
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"oldId", "newId"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "rename";
    }

    @Override
    public ValNum apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Key oldKey = Key.make(env.expand(asts[1].exec(env).getStr()));
        Key<Frame> newKey = Key.make(env.expand(asts[2].exec(env).getStr()));
        Object o2 = DKV.remove(oldKey).get();
        if (o2 instanceof Frame) {
            DKV.put(newKey, new Frame(newKey, ((Frame)o2)._names, ((Frame)o2).vecs()));
        } else if (o2 instanceof Model) {
            ((Model)o2)._key = newKey;
            DKV.put(newKey, o2);
        } else {
            throw new IllegalArgumentException("Trying to rename Value of type " + o2.getClass());
        }
        return new ValNum(Double.NaN);
    }
}

