/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.Arrays;
import water.DKV;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstStrList;
import water.rapids.vals.ValFrame;
import water.util.VecUtils;

public class AstSetDomain
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "inPlace", "newDomains"};
    }

    @Override
    public int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "setDomain";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame f2 = stk.track(asts[1].exec(env)).getFrame();
        boolean inPlace = asts[2].exec(env).getNum() == 1.0;
        String[] newDomains = ((AstStrList)asts[3])._strs;
        if (f2.numCols() != 1) {
            throw new IllegalArgumentException("Must be a single column. Got: " + f2.numCols() + " columns.");
        }
        if (!f2.vec(0).isCategorical()) {
            throw new IllegalArgumentException("Vector must be a factor column. Got: " + f2.vec(0).get_type_str());
        }
        Vec v2 = inPlace ? f2.vec(0) : env._ses.copyOnWrite(f2, new int[]{0})[0];
        if (newDomains != null && newDomains.length != v2.domain().length) {
            VecUtils.CollectDomainFast t2 = new VecUtils.CollectDomainFast((int)v2.max());
            t2.doAll(v2);
            final long[] dom = t2.domain();
            if (dom.length != newDomains.length) {
                throw new IllegalArgumentException("Number of replacement factors must equal current number of levels. Current number of levels: " + dom.length + " != " + newDomains.length);
            }
            new MRTask(){

                @Override
                public void map(Chunk c2) {
                    for (int i2 = 0; i2 < c2._len; ++i2) {
                        if (c2.isNA(i2)) continue;
                        long num = Arrays.binarySearch(dom, c2.at8(i2));
                        if (num < 0L) {
                            throw new IllegalArgumentException("Could not find the categorical value!");
                        }
                        c2.set(i2, num);
                    }
                }
            }.doAll(v2);
        }
        v2.setDomain(newDomains);
        DKV.put(v2);
        return new ValFrame(f2);
    }
}

