/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.operators;

import java.util.Arrays;
import water.Futures;
import water.H2O;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValNum;
import water.rapids.vals.ValRow;
import water.util.ArrayUtils;

public abstract class AstBinOp
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"leftArg", "rightArg"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Val left = stk.track(asts[1].exec(env));
        Val rite = stk.track(asts[2].exec(env));
        return this.prim_apply(left, rite);
    }

    public Val prim_apply(Val left, Val rite) {
        switch (left.type()) {
            case 1: {
                double dlf = left.getNum();
                switch (rite.type()) {
                    case 1: {
                        return new ValNum(this.op(dlf, rite.getNum()));
                    }
                    case 2: {
                        return new ValNum(this.op(dlf, rite.getNums()[0]));
                    }
                    case 5: {
                        return this.scalar_op_frame(dlf, rite.getFrame());
                    }
                    case 6: {
                        double[] lft = new double[rite.getRow().length];
                        Arrays.fill(lft, dlf);
                        return this.row_op_row(lft, rite.getRow(), ((ValRow)rite).getNames());
                    }
                    case 3: {
                        throw H2O.unimpl();
                    }
                    case 4: {
                        throw H2O.unimpl();
                    }
                }
                throw H2O.unimpl();
            }
            case 2: {
                double ddlf = left.getNums()[0];
                switch (rite.type()) {
                    case 1: {
                        return new ValNum(this.op(ddlf, rite.getNum()));
                    }
                    case 2: {
                        return new ValNum(this.op(ddlf, rite.getNums()[0]));
                    }
                    case 5: {
                        return this.scalar_op_frame(ddlf, rite.getFrame());
                    }
                    case 6: {
                        double[] lft = new double[rite.getRow().length];
                        Arrays.fill(lft, ddlf);
                        return this.row_op_row(lft, rite.getRow(), ((ValRow)rite).getNames());
                    }
                    case 3: {
                        throw H2O.unimpl();
                    }
                    case 4: {
                        throw H2O.unimpl();
                    }
                }
                throw H2O.unimpl();
            }
            case 5: {
                Frame flf = left.getFrame();
                switch (rite.type()) {
                    case 1: {
                        return this.frame_op_scalar(flf, rite.getNum());
                    }
                    case 2: {
                        return this.frame_op_scalar(flf, rite.getNums()[0]);
                    }
                    case 3: {
                        return this.frame_op_scalar(flf, rite.getStr());
                    }
                    case 4: {
                        return this.frame_op_scalar(flf, rite.getStrs()[0]);
                    }
                    case 5: {
                        return this.frame_op_frame(flf, rite.getFrame());
                    }
                }
                throw H2O.unimpl();
            }
            case 3: {
                String slf = left.getStr();
                switch (rite.type()) {
                    case 1: {
                        throw H2O.unimpl();
                    }
                    case 2: {
                        throw H2O.unimpl();
                    }
                    case 3: {
                        throw H2O.unimpl();
                    }
                    case 4: {
                        throw H2O.unimpl();
                    }
                    case 5: {
                        return this.scalar_op_frame(slf, rite.getFrame());
                    }
                }
                throw H2O.unimpl();
            }
            case 4: {
                String sslf = left.getStrs()[0];
                switch (rite.type()) {
                    case 1: {
                        throw H2O.unimpl();
                    }
                    case 2: {
                        throw H2O.unimpl();
                    }
                    case 3: {
                        throw H2O.unimpl();
                    }
                    case 4: {
                        throw H2O.unimpl();
                    }
                    case 5: {
                        return this.scalar_op_frame(sslf, rite.getFrame());
                    }
                }
                throw H2O.unimpl();
            }
            case 6: {
                double[] dslf = left.getRow();
                switch (rite.type()) {
                    case 1: {
                        double[] right = new double[dslf.length];
                        Arrays.fill(right, rite.getNum());
                        return this.row_op_row(dslf, right, ((ValRow)left).getNames());
                    }
                    case 6: {
                        return this.row_op_row(dslf, rite.getRow(), ((ValRow)rite).getNames());
                    }
                    case 5: {
                        return this.row_op_row(dslf, rite.getRow(), rite.getFrame().names());
                    }
                }
                throw H2O.unimpl();
            }
        }
        throw H2O.unimpl();
    }

    public abstract double op(double var1, double var3);

    public double str_op(BufferedString l2, BufferedString r2) {
        throw H2O.unimpl("Binary operation '" + this.str() + "' is not supported on String columns.");
    }

    private ValFrame scalar_op_frame(final double d2, Frame fr) {
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                for (int c2 = 0; c2 < chks.length; ++c2) {
                    Chunk chk = chks[c2];
                    NewChunk cres = cress[c2];
                    for (int i2 = 0; i2 < chk._len; ++i2) {
                        cres.addNum(AstBinOp.this.op(d2, chk.atd(i2)));
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, fr)).outputFrame(fr._names, null);
        return this.cleanCategorical(fr, res);
    }

    public ValFrame frame_op_scalar(Frame fr, final double d2) {
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                for (int c2 = 0; c2 < chks.length; ++c2) {
                    Chunk chk = chks[c2];
                    NewChunk cres = cress[c2];
                    for (int i2 = 0; i2 < chk._len; ++i2) {
                        cres.addNum(AstBinOp.this.op(chk.atd(i2), d2));
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, fr)).outputFrame(fr._names, null);
        return this.cleanCategorical(fr, res);
    }

    private ValFrame cleanCategorical(Frame oldfr, Frame newfr) {
        boolean categoricalOK = this.categoricalOK();
        Vec[] oldvecs = oldfr.vecs();
        Vec[] newvecs = newfr.vecs();
        Futures fs = new Futures();
        for (int i2 = 0; i2 < oldvecs.length; ++i2) {
            if (!oldvecs[i2].isCategorical() || categoricalOK) continue;
            Vec cv = newvecs[i2].makeCon(Double.NaN);
            newfr.replace(i2, cv).remove(fs);
        }
        fs.blockForPending();
        return new ValFrame(newfr);
    }

    private ValFrame frame_op_scalar(Frame fr, final String str) {
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                BufferedString vstr = new BufferedString();
                for (int c2 = 0; c2 < chks.length; ++c2) {
                    int i2;
                    Chunk chk = chks[c2];
                    NewChunk cres = cress[c2];
                    Vec vec = chk.vec();
                    if (vec.isString()) {
                        BufferedString conStr = new BufferedString(str);
                        for (int i3 = 0; i3 < chk._len; ++i3) {
                            cres.addNum(AstBinOp.this.str_op(chk.atStr(vstr, i3), conStr));
                        }
                        continue;
                    }
                    if (vec.isCategorical()) {
                        double d2 = ArrayUtils.find(vec.domain(), str);
                        for (i2 = 0; i2 < chk._len; ++i2) {
                            cres.addNum(AstBinOp.this.op(chk.atd(i2), d2));
                        }
                        continue;
                    }
                    double d3 = AstBinOp.this.op(1.0, 2.0);
                    for (i2 = 0; i2 < chk._len; ++i2) {
                        cres.addNum(d3);
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, fr)).outputFrame(fr._names, null);
        return new ValFrame(res);
    }

    private ValFrame scalar_op_frame(final String str, Frame fr) {
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                BufferedString vstr = new BufferedString();
                for (int c2 = 0; c2 < chks.length; ++c2) {
                    int i2;
                    Chunk chk = chks[c2];
                    NewChunk cres = cress[c2];
                    Vec vec = chk.vec();
                    if (vec.isString()) {
                        BufferedString conStr = new BufferedString(str);
                        for (int i3 = 0; i3 < chk._len; ++i3) {
                            cres.addNum(AstBinOp.this.str_op(conStr, chk.atStr(vstr, i3)));
                        }
                        continue;
                    }
                    if (vec.isCategorical()) {
                        double d2 = ArrayUtils.find(vec.domain(), str);
                        for (i2 = 0; i2 < chk._len; ++i2) {
                            cres.addNum(AstBinOp.this.op(d2, chk.atd(i2)));
                        }
                        continue;
                    }
                    double d3 = AstBinOp.this.op(1.0, 2.0);
                    for (i2 = 0; i2 < chk._len; ++i2) {
                        cres.addNum(d3);
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, fr)).outputFrame(fr._names, null);
        return new ValFrame(res);
    }

    private ValFrame frame_op_frame(Frame lf, Frame rt) {
        if (lf.numRows() != rt.numRows()) {
            if (lf.numRows() == 1L || rt.numRows() == 1L) {
                if (lf.numCols() != rt.numCols()) {
                    throw new IllegalArgumentException("Frames must have same columns, found " + lf.numCols() + " columns and " + rt.numCols() + " columns.");
                }
                return this.frame_op_row(lf, rt);
            }
            throw new IllegalArgumentException("Frames must have same rows, found " + lf.numRows() + " rows and " + rt.numRows() + " rows.");
        }
        if (lf.numCols() == 0) {
            return new ValFrame(lf);
        }
        if (rt.numCols() == 0) {
            return new ValFrame(rt);
        }
        if (lf.numCols() == 1 && rt.numCols() > 1) {
            return this.vec_op_frame(lf.vecs()[0], rt);
        }
        if (rt.numCols() == 1 && lf.numCols() > 1) {
            return this.frame_op_vec(lf, rt.vecs()[0]);
        }
        if (lf.numCols() != rt.numCols()) {
            throw new IllegalArgumentException("Frames must have same columns, found " + lf.numCols() + " columns and " + rt.numCols() + " columns.");
        }
        final int[][] alignedCategoricals = new int[lf.numCols()][];
        final boolean[] categorical = new boolean[lf.numCols()];
        final boolean[] rtDomainNotBigger = new boolean[lf.numCols()];
        for (int c2 = 0; c2 < lf.numCols(); ++c2) {
            boolean bl = categorical[c2] = this.categoricalOK() && lf.vec(c2).isCategorical() && rt.vec(c2).isCategorical();
            if (!categorical[c2]) continue;
            rtDomainNotBigger[c2] = lf.vec(c2).domain().length >= rt.vec(c2).domain().length;
            alignedCategoricals[c2] = rtDomainNotBigger[c2] ? this.alignCategoricals(lf.vec(c2).domain(), rt.vec(c2).domain()) : this.alignCategoricals(rt.vec(c2).domain(), lf.vec(c2).domain());
        }
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                BufferedString lfstr = new BufferedString();
                BufferedString rtstr = new BufferedString();
                assert (cress.length << 1 == chks.length);
                for (int c2 = 0; c2 < cress.length; ++c2) {
                    int i2;
                    Chunk clf = chks[c2];
                    Chunk crt = chks[c2 + cress.length];
                    NewChunk cres = cress[c2];
                    if (clf.vec().isString()) {
                        for (i2 = 0; i2 < clf._len; ++i2) {
                            cres.addNum(AstBinOp.this.str_op(clf.atStr(lfstr, i2), crt.atStr(rtstr, i2)));
                        }
                        continue;
                    }
                    if (categorical[c2]) {
                        if (rtDomainNotBigger[c2]) {
                            for (i2 = 0; i2 < clf._len; ++i2) {
                                double crtAtdValue = crt.atd(i2);
                                if (crt.isNA(i2)) {
                                    cres.addNum(AstBinOp.this.op(clf.atd(i2), crtAtdValue));
                                    continue;
                                }
                                cres.addNum(AstBinOp.this.op(clf.atd(i2), alignedCategoricals[c2][(int)crtAtdValue]));
                            }
                            continue;
                        }
                        for (i2 = 0; i2 < clf._len; ++i2) {
                            double clfAtdValue = clf.atd(i2);
                            if (clf.isNA(i2)) {
                                cres.addNum(AstBinOp.this.op(clfAtdValue, crt.atd(i2)));
                                continue;
                            }
                            cres.addNum(AstBinOp.this.op(alignedCategoricals[c2][(int)clfAtdValue], crt.atd(i2)));
                        }
                        continue;
                    }
                    for (i2 = 0; i2 < clf._len; ++i2) {
                        cres.addNum(AstBinOp.this.op(clf.atd(i2), crt.atd(i2)));
                    }
                }
            }
        }.doAll(lf.numCols(), (byte)3, new Frame(lf).add(rt))).outputFrame(lf._names, null);
        return this.cleanCategorical(lf, res);
    }

    private int[] alignCategoricals(String[] longerDomain, String[] shorterDomain) {
        Object[] sortedLongerDomain = Arrays.copyOf(longerDomain, longerDomain.length);
        Arrays.sort(sortedLongerDomain);
        int[] transformedIndices = MemoryManager.malloc4(shorterDomain.length);
        for (int i2 = 0; i2 < shorterDomain.length; ++i2) {
            transformedIndices[i2] = Arrays.binarySearch(sortedLongerDomain, shorterDomain[i2]);
        }
        return transformedIndices;
    }

    private ValFrame frame_op_row(Frame lf, Frame row) {
        final double[] rawRow = new double[row.numCols()];
        for (int i2 = 0; i2 < rawRow.length; ++i2) {
            rawRow[i2] = row.vec(i2).isNumeric() || row.vec(i2).isTime() ? row.vec(i2).at(0L) : Double.NaN;
        }
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                for (int c2 = 0; c2 < cress.length; ++c2) {
                    Chunk clf = chks[c2];
                    NewChunk cres = cress[c2];
                    for (int r2 = 0; r2 < clf._len; ++r2) {
                        if (clf.vec().isString()) {
                            cres.addNum(Double.NaN);
                            continue;
                        }
                        cres.addNum(AstBinOp.this.op(clf.atd(r2), rawRow[c2]));
                    }
                }
            }
        }.doAll(lf.numCols(), (byte)3, lf)).outputFrame(lf._names, null);
        return this.cleanCategorical(lf, res);
    }

    private ValRow row_op_row(double[] lf, double[] rt, String[] names) {
        double[] res = new double[lf.length];
        for (int i2 = 0; i2 < lf.length; ++i2) {
            res[i2] = this.op(lf[i2], rt[i2]);
        }
        return new ValRow(res, names);
    }

    private ValFrame vec_op_frame(Vec vec, Frame fr) {
        Frame rt = new Frame(fr);
        rt.add("", vec);
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                assert (cress.length == chks.length - 1);
                Chunk clf = chks[cress.length];
                for (int c2 = 0; c2 < cress.length; ++c2) {
                    Chunk crt = chks[c2];
                    NewChunk cres = cress[c2];
                    for (int i2 = 0; i2 < clf._len; ++i2) {
                        cres.addNum(AstBinOp.this.op(clf.atd(i2), crt.atd(i2)));
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, rt)).outputFrame(fr._names, null);
        return this.cleanCategorical(fr, res);
    }

    private ValFrame frame_op_vec(Frame fr, Vec vec) {
        Frame lf = new Frame(fr);
        lf.add("", vec);
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                assert (cress.length == chks.length - 1);
                Chunk crt = chks[cress.length];
                for (int c2 = 0; c2 < cress.length; ++c2) {
                    Chunk clf = chks[c2];
                    NewChunk cres = cress[c2];
                    for (int i2 = 0; i2 < clf._len; ++i2) {
                        cres.addNum(AstBinOp.this.op(clf.atd(i2), crt.atd(i2)));
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, lf)).outputFrame(fr._names, null);
        return this.cleanCategorical(fr, res);
    }

    public boolean categoricalOK() {
        return false;
    }
}

