/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.operators;

import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstRoot;
import water.rapids.ast.prims.operators.AstBinOp;

public class AstLAnd
extends AstBinOp {
    @Override
    public String str() {
        return "&&";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        double d2;
        Val left = stk.track(asts[1].exec(env));
        if (left.isNum() && (d2 = left.getNum()) == 0.0) {
            return left;
        }
        Val rite = stk.track(asts[2].exec(env));
        return this.prim_apply(left, rite);
    }

    @Override
    public double op(double l2, double r2) {
        return AstLAnd.and_op(l2, r2);
    }

    public static double and_op(double l2, double r2) {
        return l2 == 0.0 || r2 == 0.0 ? 0.0 : (Double.isNaN(l2) || Double.isNaN(r2) ? Double.NaN : 1.0);
    }
}

