/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.repeaters;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstRepLen
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "length"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "rep_len";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Val v2 = asts[1].exec(env);
        long length = (long)asts[2].exec(env).getNum();
        if (!(v2 instanceof ValFrame)) {
            return new ValFrame(new Frame(Vec.makeCon(v2.getNum(), length)));
        }
        Frame ff = stk.track(v2).getFrame();
        final Frame fr = ff;
        if (fr.numCols() == 1) {
            Vec vec = Vec.makeRepSeq(length, fr.numRows());
            new MRTask(){

                @Override
                public void map(Chunk c2) {
                    for (int i2 = 0; i2 < c2._len; ++i2) {
                        c2.set(i2, fr.anyVec().at((long)c2.atd(i2)));
                    }
                }
            }.doAll(vec);
            vec.setDomain(fr.anyVec().domain());
            return new ValFrame(new Frame(vec));
        }
        Frame f2 = new Frame(new Vec[0]);
        int i2 = 0;
        while ((long)i2 < length) {
            f2.add(Frame.defaultColName(f2.numCols()), fr.vec(i2 % fr.numCols()));
            ++i2;
        }
        return new ValFrame(f2);
    }
}

