/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.search;

import water.H2O;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstBuiltin;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValRow;

public abstract class AstWhichFunc
extends AstBuiltin<AstWhichFunc> {
    @Override
    public String[] args() {
        return new String[]{"frame", "na_rm", "axis"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        throw H2O.unimpl();
    }

    public abstract double op(Vec var1);

    public abstract String searchVal();

    public abstract double init();

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Val val1 = asts[1].exec(env);
        if (val1 instanceof ValFrame) {
            Frame fr = stk.track(val1).getFrame();
            boolean na_rm = asts[2].exec(env).getNum() == 1.0;
            boolean axis = asts.length == 4 && asts[3].exec(env).getNum() == 1.0;
            return axis ? this.rowwiseWhichVal(fr, na_rm) : this.colwiseWhichVal(fr, na_rm);
        }
        if (val1 instanceof ValRow) {
            double[] row = val1.getRow();
            boolean na_rm = asts[2].exec(env).getNum() == 1.0;
            double val = Double.NEGATIVE_INFINITY;
            double valIndex = 0.0;
            if (this.searchVal() == "max") {
                for (int i2 = 0; i2 < row.length; ++i2) {
                    if (Double.isNaN(row[i2])) {
                        if (na_rm) continue;
                        return new ValRow(new double[]{Double.NaN}, null);
                    }
                    if (!(row[i2] > val)) continue;
                    val = row[i2];
                    valIndex = i2;
                }
            } else if (this.searchVal() == "min") {
                for (int i3 = 0; i3 < row.length; ++i3) {
                    if (Double.isNaN(row[i3])) {
                        if (na_rm) continue;
                        return new ValRow(new double[]{Double.NaN}, null);
                    }
                    if (!(row[i3] < val)) continue;
                    val = row[i3];
                    valIndex = i3;
                }
            } else {
                throw new IllegalArgumentException("Incorrect argument: expected to search for max() or min(), received " + this.searchVal());
            }
            return new ValRow(new double[]{valIndex}, null);
        }
        throw new IllegalArgumentException("Incorrect argument: expected a frame or a row, received " + val1.getClass());
    }

    private ValFrame rowwiseWhichVal(Frame fr, final boolean na_rm) {
        Frame res;
        String[] newnames = new String[]{"which." + this.searchVal()};
        Key<Frame> newkey = Key.make();
        int n_numeric = 0;
        int n_time = 0;
        for (Vec vec : fr.vecs()) {
            if (vec.isNumeric()) {
                ++n_numeric;
            }
            if (!vec.isTime()) continue;
            ++n_time;
        }
        byte resType = n_numeric > 0 ? (byte)3 : 5;
        Frame compFrame = new Frame(new Vec[0]);
        for (int i2 = 0; i2 < fr.numCols(); ++i2) {
            Vec vec;
            vec = fr.vec(i2);
            if (!(n_numeric > 0 ? vec.isNumeric() : vec.isTime())) continue;
            compFrame.add(fr.name(i2), vec);
        }
        Vec anyvec = compFrame.anyVec();
        if (anyvec == null) {
            res = new Frame(newkey);
            anyvec = fr.anyVec();
            if (anyvec != null) {
                res.add("which." + this.searchVal(), anyvec.makeCon(Double.NaN));
            }
            return new ValFrame(res);
        }
        if (!na_rm && n_numeric < fr.numCols() && n_time < fr.numCols()) {
            res = new Frame(newkey, newnames, new Vec[]{anyvec.makeCon(Double.NaN)});
            return new ValFrame(res);
        }
        final int numCols = compFrame.numCols();
        Frame res2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk nc) {
                for (int i2 = 0; i2 < cs[0]._len; ++i2) {
                    double val;
                    int j2;
                    int numNaColumns = 0;
                    double value = Double.NEGATIVE_INFINITY;
                    int valueIndex = 0;
                    if (AstWhichFunc.this.searchVal() == "max") {
                        for (j2 = 0; j2 < numCols; ++j2) {
                            val = cs[j2].atd(i2);
                            if (Double.isNaN(val)) {
                                ++numNaColumns;
                                continue;
                            }
                            if (!(val > value)) continue;
                            value = val;
                            valueIndex = j2;
                        }
                    } else if (AstWhichFunc.this.searchVal() == "min") {
                        for (j2 = 0; j2 < numCols; ++j2) {
                            val = cs[j2].atd(i2);
                            if (Double.isNaN(val)) {
                                ++numNaColumns;
                                continue;
                            }
                            if (!(val < value)) continue;
                            value = val;
                            valueIndex = j2;
                        }
                    } else {
                        throw new IllegalArgumentException("Incorrect argument: expected to search for max() or min(), received " + AstWhichFunc.this.searchVal());
                    }
                    if (na_rm ? numNaColumns < numCols : numNaColumns == 0) {
                        nc.addNum(valueIndex);
                        continue;
                    }
                    nc.addNum(Double.NaN);
                }
            }
        }.doAll(1, resType, compFrame)).outputFrame(newkey, newnames, null);
        return new ValFrame(res2);
    }

    private ValFrame colwiseWhichVal(Frame fr, boolean na_rm) {
        Frame res = new Frame(new Vec[0]);
        Vec vec1 = Vec.makeCon(null, 0.0);
        assert (vec1.length() == 1L);
        for (int i2 = 0; i2 < fr.numCols(); ++i2) {
            Vec v2 = fr.vec(i2);
            double searchValue = this.op(v2);
            boolean valid = !(!v2.isNumeric() && !v2.isTime() && !v2.isBinary() || v2.length() <= 0L || !na_rm && v2.naCnt() != 0L);
            FindIndexCol findIndexCol = (FindIndexCol)new FindIndexCol(searchValue).doAll(new byte[]{3}, v2);
            Vec newvec = vec1.makeCon(valid ? findIndexCol._valIndex : Double.NaN, v2.isTime() ? (byte)5 : 3);
            res.add(fr.name(i2), newvec);
        }
        vec1.remove();
        return new ValFrame(res);
    }

    private static class FindIndexCol
    extends MRTask<FindIndexCol> {
        double _val;
        double _valIndex;

        FindIndexCol(double val) {
            this._val = val;
            this._valIndex = Double.POSITIVE_INFINITY;
        }

        @Override
        public void map(Chunk c2, NewChunk nc) {
            long start = c2.start();
            for (int i2 = 0; i2 < c2._len; ++i2) {
                if (c2.atd(i2) != this._val) continue;
                this._valIndex = start + (long)i2;
                break;
            }
        }

        @Override
        public void reduce(FindIndexCol mic) {
            this._valIndex = Math.min(this._valIndex, mic._valIndex);
        }
    }
}

