/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstCountSubstringsWords
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "words"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "num_valid_substrings";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        String wordsPath = asts[2].exec(env).getStr();
        for (Vec v2 : fr.vecs()) {
            if (v2.isCategorical() || v2.isString()) continue;
            throw new IllegalArgumentException("num_valid_substrings() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        HashSet<String> words = null;
        try {
            words = new HashSet<String>(FileUtils.readLines((File)new File(wordsPath)));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i2 = 0;
        for (Vec v3 : fr.vecs()) {
            nvs[i2] = v3.isCategorical() ? this.countSubstringsWordsCategoricalCol(v3, words) : this.countSubstringsWordsStringCol(v3, words);
            ++i2;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec countSubstringsWordsCategoricalCol(Vec vec, final HashSet<String> words) {
        Vec res = ((MRTask)new MRTask(){
            transient double[] catCounts;

            @Override
            public void setupLocal() {
                String[] doms = this._fr.anyVec().domain();
                this.catCounts = new double[doms.length];
                for (int i2 = 0; i2 < doms.length; ++i2) {
                    this.catCounts[i2] = AstCountSubstringsWords.this.calcCountSubstringsWords(doms[i2], words);
                }
            }

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                newChk.alloc_doubles(chk._len);
                for (int i2 = 0; i2 < chk._len; ++i2) {
                    if (chk.isNA(i2)) {
                        newChk.addNA();
                        continue;
                    }
                    newChk.addNum(this.catCounts[(int)chk.atd(i2)]);
                }
            }
        }.doAll(1, (byte)3, new Frame(vec))).outputFrame().anyVec();
        return res;
    }

    private Vec countSubstringsWordsStringCol(Vec vec, final HashSet<String> words) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    newChk.addNAs(chk.len());
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i2 = 0; i2 < chk._len; ++i2) {
                        if (chk.isNA(i2)) {
                            newChk.addNA();
                            continue;
                        }
                        String str = chk.atStr(tmpStr, i2).toString();
                        newChk.addNum(AstCountSubstringsWords.this.calcCountSubstringsWords(str, words));
                    }
                }
            }
        }.doAll(new byte[]{3}, vec)).outputFrame().anyVec();
    }

    private int calcCountSubstringsWords(String str, HashSet<String> words) {
        int wordCount = 0;
        int N2 = str.length();
        for (int i2 = 0; i2 < N2 - 1; ++i2) {
            for (int j2 = i2 + 2; j2 < N2 + 1; ++j2) {
                if (!words.contains(str.substring(i2, j2))) continue;
                ++wordCount;
            }
        }
        return wordCount;
    }
}

