/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.VecUtils;

public class AstLStrip
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "set"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "lstrip";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        String set = asts[2].exec(env).getStr();
        for (Vec v2 : fr.vecs()) {
            if (v2.isCategorical() || v2.isString()) continue;
            throw new IllegalArgumentException("trim() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i2 = 0;
        for (Vec v3 : fr.vecs()) {
            nvs[i2] = v3.isCategorical() ? this.lstripCategoricalCol(v3, set) : this.lstripStringCol(v3, set);
            ++i2;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec lstripCategoricalCol(Vec vec, String set) {
        String[] doms = (String[])vec.domain().clone();
        HashMap<String, ArrayList<Integer>> strippedToOldDomainIndices = new HashMap<String, ArrayList<Integer>>();
        for (int i2 = 0; i2 < doms.length; ++i2) {
            String stripped;
            doms[i2] = stripped = StringUtils.stripStart((String)doms[i2], (String)set);
            if (!strippedToOldDomainIndices.containsKey(stripped)) {
                ArrayList<Integer> val = new ArrayList<Integer>();
                val.add(i2);
                strippedToOldDomainIndices.put(stripped, val);
                continue;
            }
            strippedToOldDomainIndices.get(stripped).add(i2);
        }
        if (strippedToOldDomainIndices.size() < doms.length) {
            return VecUtils.DomainDedupe.domainDeduper(vec, strippedToOldDomainIndices);
        }
        return vec.makeCopy(doms);
    }

    private Vec lstripStringCol(Vec vec, String set) {
        final String charSet = set;
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i2 = 0; i2 < chk.len(); ++i2) {
                        newChk.addNA();
                    }
                } else if (((CStrChunk)chk)._isAllASCII && StringUtils.isAsciiPrintable((String)charSet)) {
                    ((CStrChunk)chk).asciiLStrip(newChk, charSet);
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i3 = 0; i3 < chk.len(); ++i3) {
                        if (chk.isNA(i3)) {
                            newChk.addNA();
                            continue;
                        }
                        newChk.addStr(StringUtils.stripStart((String)chk.atStr(tmpStr, i3).toString(), (String)charSet));
                    }
                }
            }
        }.doAll(new byte[]{2}, vec)).outputFrame().anyVec();
    }
}

