/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstStrLength
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "strlen";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        for (Vec v2 : fr.vecs()) {
            if (v2.isCategorical() || v2.isString()) continue;
            throw new IllegalArgumentException("length() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i2 = 0;
        for (Vec v3 : fr.vecs()) {
            nvs[i2] = v3.isCategorical() ? this.lengthCategoricalCol(v3) : this.lengthStringCol(v3);
            ++i2;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec lengthCategoricalCol(Vec vec) {
        Vec res = ((MRTask)new MRTask(){
            transient int[] catLengths;

            @Override
            public void setupLocal() {
                String[] doms = this._fr.anyVec().domain();
                this.catLengths = new int[doms.length];
                for (int i2 = 0; i2 < doms.length; ++i2) {
                    this.catLengths[i2] = doms[i2].length();
                }
            }

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                newChk.alloc_nums(chk._len);
                for (int i2 = 0; i2 < chk._len; ++i2) {
                    if (chk.isNA(i2)) {
                        newChk.addNA();
                        continue;
                    }
                    newChk.addNum(this.catLengths[(int)chk.atd(i2)], 0);
                }
            }
        }.doAll(1, (byte)3, new Frame(vec))).outputFrame().anyVec();
        return res;
    }

    private Vec lengthStringCol(Vec vec) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i2 = 0; i2 < chk._len; ++i2) {
                        newChk.addNA();
                    }
                } else if (((CStrChunk)chk)._isAllASCII) {
                    ((CStrChunk)chk).asciiLength(newChk);
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i3 = 0; i3 < chk._len; ++i3) {
                        if (chk.isNA(i3)) {
                            newChk.addNA();
                            continue;
                        }
                        newChk.addNum(chk.atStr(tmpStr, i3).toString().length(), 0);
                    }
                }
            }
        }.doAll(new byte[]{3}, vec)).outputFrame().anyVec();
    }
}

