/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.util.ArrayList;
import java.util.HashMap;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNumList;
import water.rapids.vals.ValFrame;
import water.util.VecUtils;

public class AstSubstring
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "startIndex", "endIndex"};
    }

    @Override
    public int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "substring";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        int startIndex = (int)asts[2].exec(env).getNum();
        if (startIndex < 0) {
            startIndex = 0;
        }
        int endIndex = asts[3] instanceof AstNumList ? Integer.MAX_VALUE : (int)asts[3].exec(env).getNum();
        for (Vec v2 : fr.vecs()) {
            if (v2.isCategorical() || v2.isString()) continue;
            throw new IllegalArgumentException("substring() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i2 = 0;
        for (Vec v3 : fr.vecs()) {
            nvs[i2] = v3.isCategorical() ? this.substringCategoricalCol(v3, startIndex, endIndex) : this.substringStringCol(v3, startIndex, endIndex);
            ++i2;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec substringCategoricalCol(Vec vec, int startIndex, int endIndex) {
        if (startIndex >= endIndex) {
            Vec v2 = Vec.makeZero(vec.length());
            v2.setDomain(new String[]{""});
            return v2;
        }
        String[] dom = (String[])vec.domain().clone();
        HashMap<String, ArrayList<Integer>> substringToOldDomainIndices = new HashMap<String, ArrayList<Integer>>();
        for (int i2 = 0; i2 < dom.length; ++i2) {
            String substr;
            dom[i2] = substr = dom[i2].substring(startIndex < dom[i2].length() ? startIndex : dom[i2].length(), endIndex < dom[i2].length() ? endIndex : dom[i2].length());
            if (!substringToOldDomainIndices.containsKey(substr)) {
                ArrayList<Integer> val = new ArrayList<Integer>();
                val.add(i2);
                substringToOldDomainIndices.put(substr, val);
                continue;
            }
            substringToOldDomainIndices.get(substr).add(i2);
        }
        if (substringToOldDomainIndices.size() < dom.length) {
            return VecUtils.DomainDedupe.domainDeduper(vec, substringToOldDomainIndices);
        }
        return vec.makeCopy(dom);
    }

    private Vec substringStringCol(Vec vec, final int startIndex, final int endIndex) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i2 = 0; i2 < chk.len(); ++i2) {
                        newChk.addNA();
                    }
                } else if (startIndex >= endIndex) {
                    for (int i3 = 0; i3 < chk.len(); ++i3) {
                        newChk.addStr("");
                    }
                } else if (((CStrChunk)chk)._isAllASCII) {
                    ((CStrChunk)chk).asciiSubstring(newChk, startIndex, endIndex);
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i4 = 0; i4 < chk._len; ++i4) {
                        String str;
                        if (chk.isNA(i4)) {
                            newChk.addNA();
                            continue;
                        }
                        newChk.addStr(str.substring(startIndex < (str = chk.atStr(tmpStr, i4).toString()).length() ? startIndex : str.length(), endIndex < str.length() ? endIndex : str.length()));
                    }
                }
            }
        }.doAll(new byte[]{2}, vec)).outputFrame().anyVec();
    }
}

