/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.util.Locale;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstToLower
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "tolower";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        for (Vec v2 : fr.vecs()) {
            if (v2.isCategorical() || v2.isString()) continue;
            throw new IllegalArgumentException("tolower() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i2 = 0;
        for (Vec v3 : fr.vecs()) {
            nvs[i2] = v3.isCategorical() ? this.toLowerCategoricalCol(v3) : AstToLower.toLowerStringCol(v3);
            ++i2;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec toLowerCategoricalCol(Vec vec) {
        String[] dom = (String[])vec.domain().clone();
        for (int i2 = 0; i2 < dom.length; ++i2) {
            dom[i2] = dom[i2].toLowerCase(Locale.ENGLISH);
        }
        return vec.makeCopy(dom);
    }

    public static Vec toLowerStringCol(Vec vec) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i2 = 0; i2 < chk.len(); ++i2) {
                        newChk.addNA();
                    }
                } else if (((CStrChunk)chk)._isAllASCII) {
                    ((CStrChunk)chk).asciiToLower(newChk);
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i3 = 0; i3 < chk._len; ++i3) {
                        if (chk.isNA(i3)) {
                            newChk.addNA();
                            continue;
                        }
                        newChk.addStr(chk.atStr(tmpStr, i3).toString().toLowerCase(Locale.ENGLISH));
                    }
                }
            }
        }.doAll(new byte[]{2}, vec)).outputFrame().anyVec();
    }
}

