/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.time;

import java.util.ArrayList;
import org.joda.time.Chronology;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.chrono.ISOChronology;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Val;
import water.rapids.ast.AstBuiltin;
import water.rapids.vals.ValFrame;
import water.util.ArrayUtils;

public class AstMoment
extends AstBuiltin<AstMoment> {
    @Override
    public int nargs() {
        return 8;
    }

    @Override
    public String[] args() {
        return new String[]{"yr", "mo", "dy", "hr", "mi", "se", "ms"};
    }

    @Override
    public String str() {
        return "moment";
    }

    @Override
    protected ValFrame exec(Val[] args) {
        Frame fr;
        boolean naResult = false;
        long numRows = -1L;
        int[] timeparts = new int[7];
        ArrayList<Integer> chunksmap = new ArrayList<Integer>(7);
        ArrayList<Vec> timevecs = new ArrayList<Vec>(7);
        for (int i2 = 0; i2 < 7; ++i2) {
            Val vi = args[i2 + 1];
            if (vi.isFrame()) {
                fr = vi.getFrame();
                if (fr.numCols() != 1) {
                    throw new IllegalArgumentException("Argument " + i2 + " is a frame with " + fr.numCols() + " columns");
                }
                if (!fr.vec(0).isNumeric()) {
                    throw new IllegalArgumentException("Argument " + i2 + " is not a numeric column");
                }
                if (fr.numRows() == 0L) {
                    throw new IllegalArgumentException("Column " + i2 + " has 0 rows");
                }
                if (fr.numRows() == 1L) {
                    double d2 = fr.vec(0).at(0L);
                    if (Double.isNaN(d2)) {
                        naResult = true;
                        continue;
                    }
                    timeparts[i2] = (int)d2;
                    continue;
                }
                if (numRows == -1L) {
                    numRows = fr.numRows();
                }
                if (fr.numRows() != numRows) {
                    throw new IllegalArgumentException("Incompatible vec " + i2 + " having " + fr.numRows() + " rows, whereas other vecs have " + numRows + " rows.");
                }
                timevecs.add(fr.vec(0));
                chunksmap.add(i2);
                continue;
            }
            if (vi.isNum()) {
                double d3 = vi.getNum();
                if (Double.isNaN(d3)) {
                    naResult = true;
                    continue;
                }
                timeparts[i2] = (int)d3;
                continue;
            }
            throw new IllegalArgumentException("Argument " + i2 + " is neither a number nor a frame");
        }
        if (timevecs.isEmpty()) {
            double val = Double.NaN;
            if (!naResult) {
                try {
                    val = ISOChronology.getInstanceUTC().getDateTimeMillis(timeparts[0], timeparts[1], timeparts[2], timeparts[3], timeparts[4], timeparts[5], timeparts[6]);
                }
                catch (IllegalFieldValueException d3) {
                    // empty catch block
                }
            }
            return this.make1x1Frame(val);
        }
        if (naResult) {
            long n2 = ((Vec)timevecs.get(0)).length();
            Vec v2 = Vec.makeCon(Double.NaN, n2, (byte)5);
            Frame fr2 = new Frame(Key.make(), new String[]{"time"}, new Vec[]{v2});
            return new ValFrame(fr2);
        }
        Vec[] vecs = timevecs.toArray(new Vec[timevecs.size()]);
        int[] cm = ArrayUtils.toPrimitive(chunksmap);
        fr = ((SetTimeTask)new SetTimeTask(timeparts, cm).doAll((byte)5, vecs)).outputFrame(new String[]{"time"}, null);
        return new ValFrame(fr);
    }

    private ValFrame make1x1Frame(double val) {
        Vec v2 = Vec.makeTimeVec(new double[]{val}, null);
        Frame f2 = new Frame(new String[]{"time"}, new Vec[]{v2});
        return new ValFrame(f2);
    }

    private static class SetTimeTask
    extends MRTask<SetTimeTask> {
        private int[] tp;
        private int[] cm;

        public SetTimeTask(int[] timeparts, int[] chunksmap) {
            this.tp = timeparts;
            this.cm = chunksmap;
        }

        @Override
        public void map(Chunk[] chks, NewChunk nc) {
            int nVecs = this.cm.length;
            assert (chks.length == nVecs);
            ISOChronology chronology = ISOChronology.getInstanceUTC();
            int nChunkRows = chks[0]._len;
            int[] tpl = new int[this.tp.length];
            System.arraycopy(this.tp, 0, tpl, 0, this.tp.length);
            block2: for (int i2 = 0; i2 < nChunkRows; ++i2) {
                for (int j2 = 0; j2 < nVecs; ++j2) {
                    double d2 = chks[j2].atd(i2);
                    if (Double.isNaN(d2)) {
                        nc.addNum(Double.NaN);
                        continue block2;
                    }
                    tpl[this.cm[j2]] = (int)d2;
                }
                try {
                    double millis = ((Chronology)chronology).getDateTimeMillis(tpl[0], tpl[1], tpl[2], tpl[3], tpl[4], tpl[5], tpl[6]);
                    nc.addNum(millis);
                    continue;
                }
                catch (IllegalFieldValueException e2) {
                    nc.addNum(Double.NaN);
                }
            }
        }
    }
}

