/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.transforms;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang.ArrayUtils;
import water.DKV;
import water.H2O;
import water.fvec.Frame;
import water.rapids.Session;
import water.rapids.ast.AstExec;
import water.rapids.ast.AstParameter;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstId;
import water.rapids.ast.prims.mungers.AstColPySlice;
import water.rapids.transforms.Transform;

public class H2OColOp
extends Transform<H2OColOp> {
    private static final String FRAME_ID_PLACEHOLDER = "dummy";
    protected final String _fun;
    private final String _oldCol;
    private String[] _newCol;
    private String _newColTypes;
    boolean _multiColReturn;

    public H2OColOp(String name, String ast, boolean inplace, String[] newNames) {
        super(name, ast, inplace, newNames);
        this._fun = this._ast._asts[0].str();
        this._oldCol = H2OColOp.findOldName((AstExec)this._ast._asts[1]);
        this.setupParams();
    }

    private void setupParams() {
        String[] args = this._ast.getArgs();
        if (args != null && args.length > 1) {
            for (int i2 = 1; i2 < args.length; ++i2) {
                this.setupParamsImpl(i2, args);
            }
        }
    }

    protected void setupParamsImpl(int i2, String[] args) {
        this._params.put(args[i2], (AstParameter)this._ast._asts[i2 + 1]);
    }

    @Override
    public Transform<H2OColOp> fit(Frame f2) {
        return this;
    }

    @Override
    protected Frame transformImpl(Frame f2) {
        this.substitutePlaceholders(this._ast, f2);
        Session ses = new Session();
        Frame fr = ses.exec(this._ast, null).getFrame();
        this._newCol = this._newNames == null ? new String[fr.numCols()] : this._newNames;
        this._newColTypes = H2OColOp.toJavaPrimitive(fr.anyVec().get_type_str());
        this._multiColReturn = fr.numCols() > 1;
        if (this._multiColReturn) {
            for (int i2 = 0; i2 < this._newCol.length; ++i2) {
                if (this._newNames == null) {
                    this._newCol[i2] = f2.uniquify(i2 > 0 ? this._newCol[i2 - 1] : this._oldCol);
                }
                f2.add(this._newCol[i2], fr.vec(i2));
            }
            if (this._inplace) {
                f2.remove(f2.find(this._oldCol)).remove();
            }
        } else {
            String[] stringArray;
            if (this._newNames == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this._inplace ? this._oldCol : f2.uniquify(this._oldCol);
            } else {
                stringArray = this._newCol = this._newCol;
            }
            if (this._inplace) {
                f2.replace(f2.find(this._oldCol), fr.anyVec()).remove();
            } else {
                f2.add(this._newNames == null ? this._newCol[0] : this._newNames[0], fr.anyVec());
            }
        }
        DKV.put(f2);
        return f2;
    }

    private void substitutePlaceholders(AstExec root, Frame f2) {
        LinkedList<AstExec> execs = new LinkedList<AstExec>();
        execs.add(root);
        while (!execs.isEmpty()) {
            AstExec exec = (AstExec)execs.poll();
            for (int i2 = 1; i2 < exec._asts.length; ++i2) {
                AstId id;
                AstRoot ast = exec._asts[i2];
                if (ast instanceof AstExec) {
                    execs.add((AstExec)ast);
                    continue;
                }
                if (!(ast instanceof AstId) || !FRAME_ID_PLACEHOLDER.equals((id = (AstId)ast).str())) continue;
                exec._asts[i2] = new AstId(f2);
            }
        }
    }

    private static String findOldName(AstExec root) {
        AstColPySlice py = new AstColPySlice();
        LinkedList<AstExec> execs = new LinkedList<AstExec>();
        execs.add(root);
        String oldName = null;
        while (!execs.isEmpty()) {
            AstExec exec = (AstExec)execs.poll();
            if (exec._asts.length == 3 && py.str().equals(exec._asts[0].str()) && FRAME_ID_PLACEHOLDER.equals(exec._asts[1].str())) {
                oldName = exec._asts[2].str();
                break;
            }
            for (int i2 = 1; i2 < exec._asts.length; ++i2) {
                AstRoot ast = exec._asts[i2];
                if (!(ast instanceof AstExec)) continue;
                execs.add((AstExec)ast);
            }
        }
        return oldName;
    }

    @Override
    Frame inverseTransform(Frame f2) {
        throw H2O.unimpl();
    }

    @Override
    public String genClassImpl() {
        String typeCast;
        int typeId = ArrayUtils.indexOf((Object[])this._inNames, (Object)this._oldCol);
        if (typeId < 0) {
            throw new IllegalStateException("Unknown column " + this._oldCol + " (known: " + Arrays.toString(this._inNames));
        }
        String string = typeCast = this._inTypes[typeId].equals("Numeric") ? "Double" : "String";
        if (this._multiColReturn) {
            StringBuilder sb = new StringBuilder("    @Override public RowData transform(RowData row) {\n" + (this.paramIsRow() ? this.addRowParam() : "") + "     " + this._newColTypes + "[] res = GenMunger." + this.lookup(this._fun) + "((" + typeCast + ")row.get(\"" + this._oldCol + "\"), _params);\n");
            for (int i2 = 0; i2 < this._newCol.length; ++i2) {
                sb.append("      row.put(\"" + this._newCol[i2] + "\",(" + i2 + ">=res.length)?\"\":res[" + i2 + "]);\n");
            }
            sb.append("      return row;\n    }\n");
            return sb.toString();
        }
        return "    @Override public RowData transform(RowData row) {\n" + (this.paramIsRow() ? this.addRowParam() : "") + "      " + this._newColTypes + " res = GenMunger." + this.lookup(this._fun) + "((" + typeCast + ")row.get(\"" + this._oldCol + "\"), _params);\n      row.put(\"" + this._newCol[0] + "\", res);\n      return row;\n    }\n";
    }

    protected boolean paramIsRow() {
        return false;
    }

    protected String addRowParam() {
        return "";
    }

    protected String lookup(String op) {
        return op.replaceAll("\\.", "");
    }
}

