/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import water.fvec.Chunk;
import water.fvec.RawChunk;
import water.fvec.Vec;
import water.udf.Column;
import water.udf.DependentChunk;
import water.udf.FunColumnBase;
import water.udf.TypedChunk;
import water.util.Java7;
import water.util.fp.Foldable;

public class FoldingColumn<X, Y>
extends FunColumnBase<Y> {
    private final Foldable<X, Y> f;
    private final Column<X>[] columns;

    @Override
    public int rowLayout() {
        return this.columns.length > 0 ? this.columns[0].rowLayout() : 0;
    }

    public FoldingColumn() {
        this.f = null;
        this.columns = null;
    }

    public FoldingColumn(Foldable<X, Y> f2, Column<X> ... columns) {
        super(columns.length == 0 ? null : columns[0]);
        assert (columns.length > 0) : "Require at least one column for folding";
        this.f = f2;
        this.columns = columns;
        if (columns.length > 1) {
            Column<X> c0 = columns[0];
            for (int i2 = 1; i2 < columns.length; ++i2) {
                Column<X> c2 = columns[i2];
                assert (c0.isCompatibleWith(c2)) : "Columns must be compatible; " + c0 + " vs #" + i2 + ": " + c2;
            }
        }
    }

    public FoldingColumn(Foldable<X, Y> f2, Iterable<Column<X>> columns) {
        super(columns.iterator().next());
        this.f = f2;
        ArrayList<Column<X>> list = new ArrayList<Column<X>>();
        for (Column<X> column : columns) {
            list.add(column);
        }
        this.columns = (Column[])list.toArray();
    }

    @Override
    public Y get(long idx) {
        Y y2 = this.f.initial();
        for (Column<X> col : this.columns) {
            y2 = this.f.apply(y2, col.apply(idx));
        }
        return y2;
    }

    @Override
    public TypedChunk<Y> chunkAt(int i2) {
        LinkedList chunks = new LinkedList();
        for (Column<X> c2 : this.columns) {
            chunks.add(c2.chunkAt(i2));
        }
        return new FunChunk(chunks);
    }

    @Override
    public boolean isNA(long idx) {
        for (Column<X> col : this.columns) {
            if (!col.isNA(idx)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 instanceof FoldingColumn) {
            FoldingColumn other = (FoldingColumn)o2;
            return Java7.Objects.equals(this.f, other.f) && Arrays.equals(this.columns, other.columns);
        }
        return false;
    }

    public int hashCode() {
        return 61 * Arrays.hashCode(this.columns) + Java7.Objects.hashCode(this.f);
    }

    private class FunChunk
    extends DependentChunk<Y> {
        private final List<TypedChunk<X>> chunks;
        private RawChunk myChunk;

        public FunChunk(List<TypedChunk<X>> chunks) {
            super(chunks.get(0));
            this.myChunk = new RawChunk(this);
            this.chunks = chunks;
        }

        @Override
        public Vec vec() {
            return FoldingColumn.this.vec();
        }

        @Override
        public Chunk rawChunk() {
            return this.myChunk;
        }

        @Override
        public boolean isNA(int i2) {
            for (TypedChunk c2 : this.chunks) {
                if (!c2.isNA(i2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Y get(int idx) {
            Object y2 = FoldingColumn.this.f.initial();
            for (TypedChunk c2 : this.chunks) {
                y2 = FoldingColumn.this.f.apply(y2, c2.get(idx));
            }
            return y2;
        }
    }
}

