/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.udf.Column;
import water.udf.ColumnFactory;
import water.udf.DataChunk;
import water.udf.DataColumn;
import water.udf.DataColumns;
import water.udf.specialized.Enums;
import water.util.fp.Function;

public class UnfoldingFrame<X>
extends Frame {
    protected final ColumnFactory<X> factory;
    protected final long len;
    protected final Function<Long, List<X>> function;
    protected final int width;

    public UnfoldingFrame() {
        super(new Vec[0]);
        this.factory = null;
        this.len = -1L;
        this.function = null;
        this.width = -1;
    }

    public UnfoldingFrame(ColumnFactory<X> factory, long len, Function<Long, List<X>> function, int width) {
        super(new Vec[0]);
        this.factory = factory;
        this.len = len;
        this.function = function;
        this.width = width;
        assert (len >= 0L) : "Frame must have a nonnegative length, but found" + len;
        assert (width >= 0) : "Multicolumn frame must have a nonnegative width, but found" + width;
    }

    public static <X> UnfoldingFrame<X> unfoldingFrame(ColumnFactory<X> factory, final Column<List<X>> master, int width) {
        return new UnfoldingFrame<X>(factory, master.size(), master, width){

            @Override
            protected Vec buildZeroVec() {
                Vec v0 = DataColumns.buildZeroVec(this.len, this.factory.typeCode());
                v0.align(master.vec());
                return v0;
            }
        };
    }

    public static <X> UnfoldingEnumFrame UnfoldingEnumFrame(final Column<List<Integer>> master, int width, String[] domain) {
        return new UnfoldingEnumFrame(master.size(), master, width, domain){

            @Override
            protected Vec buildZeroVec() {
                Vec v0 = DataColumns.buildZeroVec(this.len, (byte)4);
                v0.align(master.vec());
                return v0;
            }
        };
    }

    protected Vec buildZeroVec() {
        return DataColumns.buildZeroVec(this.len, this.factory.typeCode());
    }

    protected List<Vec> makeVecs() throws IOException {
        Vec[] vecs = new Vec[this.width];
        for (int j2 = 0; j2 < this.width; ++j2) {
            vecs[j2] = this.buildZeroVec();
        }
        MRTask task = new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                int size = cs[0].len();
                long start = cs[0].start();
                for (int r2 = 0; r2 < size; ++r2) {
                    long i2 = (long)r2 + start;
                    List values = UnfoldingFrame.this.function.apply(i2);
                    for (int j2 = 0; j2 < cs.length; ++j2) {
                        DataChunk tc = (DataChunk)UnfoldingFrame.this.factory.apply(cs[j2]);
                        tc.set(r2, j2 < values.size() ? (Object)values.get(j2) : null);
                    }
                }
            }
        };
        Object mrTask = task.doAll(vecs);
        return Arrays.asList(((MRTask)mrTask)._fr.vecs());
    }

    public List<DataColumn<X>> materialize() throws IOException {
        List<Vec> vecs = this.makeVecs();
        ArrayList<DataColumn<X>> result = new ArrayList<DataColumn<X>>(this.width);
        for (Vec vec : vecs) {
            result.add(this.factory.newColumn(vec));
        }
        return result;
    }

    static class UnfoldingEnumFrame
    extends UnfoldingFrame<Integer> {
        private final String[] domain;

        public UnfoldingEnumFrame() {
            this.domain = null;
        }

        public UnfoldingEnumFrame(long length, Function<Long, List<Integer>> function, int width, String[] domain) {
            super(Enums.enums(domain), length, function, width);
            this.domain = domain;
            assert (domain != null) : "An enum must have a domain";
            assert (domain.length > 0) : "Domain cannot be empty";
        }
    }
}

