/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.zip.GZIPOutputStream;
import water.Iced;

public class CompressionFactory
extends Iced<CompressionFactory> {
    private final String _name;

    private CompressionFactory(String name) {
        this._name = name;
    }

    OutputStream wrapOutputStream(OutputStream os2) throws IOException {
        String n2;
        switch (n2 = this._name.toLowerCase()) {
            case "none": {
                return os2;
            }
            case "gzip": {
                return new GZIPOutputStream(os2);
            }
            case "bzip2": {
                return this.wrapDynamic("org.python.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream", os2);
            }
            case "snappy": {
                return this.wrapDynamic("org.xerial.snappy.SnappyOutputStream", os2);
            }
        }
        return this.wrapDynamic(this._name, os2);
    }

    private OutputStream wrapDynamic(String className, OutputStream os2) {
        try {
            Class<?> cls = Class.forName(className);
            Constructor<?> constructor = cls.getConstructor(OutputStream.class);
            return (OutputStream)constructor.newInstance(os2);
        }
        catch (ReflectiveOperationException e2) {
            throw new IllegalArgumentException("Cannot create a compressor using class " + className, e2);
        }
    }

    private void checkAvailability() {
        try {
            this.wrapOutputStream(new ByteArrayOutputStream());
        }
        catch (IOException e2) {
            throw new IllegalStateException("Initialization failed for compression method " + this._name, e2);
        }
    }

    public static CompressionFactory make(String name) {
        CompressionFactory cf = new CompressionFactory(name);
        cf.checkAvailability();
        return cf;
    }

    public String getName() {
        return this._name;
    }
}

