/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Arrays;
import water.H2O;

public final class DistributedException
extends RuntimeException {
    public DistributedException() {
        this.truncateStackTrace(true);
    }

    public DistributedException(Throwable cause) {
        this(cause, true);
    }

    public DistributedException(Throwable cause, boolean keepStackTrace) {
        super("DistributedException from " + H2O.SELF + ": '" + cause.getMessage() + "'", cause);
        this.truncateStackTrace(keepStackTrace);
    }

    public DistributedException(String msg, Throwable cause) {
        super(msg, cause);
        try {
            this.truncateStackTrace(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return this.getMessage() + ", caused by " + this.getCause().toString();
    }

    private void truncateStackTrace(boolean keepStackTrace) {
        if (keepStackTrace) {
            int i2;
            StackTraceElement[] stackTrace = this.getStackTrace();
            for (i2 = 0; !(i2 >= stackTrace.length || stackTrace[i2].getFileName() != null && stackTrace[i2].getFileName().equals("JettyHTTPD.java")); ++i2) {
            }
            this.setStackTrace(Arrays.copyOf(stackTrace, i2));
        } else {
            this.setStackTrace(new StackTraceElement[0]);
        }
    }
}

