/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang.ArrayUtils;
import water.AutoBuffer;
import water.Freezable;
import water.H2O;
import water.Iced;

public abstract class IcedHashMapBase<K, V>
extends Iced
implements Map<K, V>,
Cloneable,
Serializable {
    private volatile transient boolean _write_lock;
    private static final byte empty_map = -1;

    protected abstract Map<K, V> map();

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    public boolean isEmpty() {
        return this.map().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map().get(key);
    }

    @Override
    public V put(K key, V value) {
        assert (this.writeable());
        return this.map().put(key, value);
    }

    @Override
    public V remove(Object key) {
        assert (this.writeable());
        return this.map().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        assert (this.writeable());
        this.map().putAll(m4);
    }

    @Override
    public void clear() {
        assert (this.writeable());
        this.map().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map().entrySet();
    }

    @Override
    public boolean equals(Object o2) {
        return this.map().equals(o2);
    }

    @Override
    public int hashCode() {
        return this.map().hashCode();
    }

    public String toString() {
        return this.map().toString();
    }

    static KeyType keyType(byte mode) {
        return KeyType.values()[mode & 3];
    }

    static ValueType valueType(byte mode) {
        return ValueType.values()[mode >>> 2 & 0xF];
    }

    static ArrayType arrayType(byte mode) {
        return ArrayType.values()[mode >>> 6 & 3];
    }

    private static byte getMode(KeyType keyType, ValueType valueType, ArrayType arrayType) {
        return (byte)(arrayType.ordinal() << 6 | valueType.ordinal() << 2 | keyType.ordinal());
    }

    private KeyType getKeyType(K key) {
        assert (key != null);
        return Stream.of(KeyType.values()).filter(t2 -> this.isValidKey(key, (KeyType)((Object)t2))).findFirst().orElseThrow(() -> new IllegalArgumentException("keys of type " + key.getClass().getTypeName() + " are not supported"));
    }

    private ValueType getValueType(V value) {
        ArrayType arrayType = this.getArrayType(value);
        return Stream.of(ValueType.values()).filter(t2 -> this.isValidValue(value, (ValueType)((Object)t2), arrayType)).findFirst().orElseThrow(() -> new IllegalArgumentException("values of type " + value.getClass().getTypeName() + " are not supported"));
    }

    private ArrayType getArrayType(V value) {
        if (value != null && value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                return ArrayType.PrimitiveArray;
            }
            return ArrayType.Array;
        }
        return ArrayType.None;
    }

    boolean isValidKey(K key, KeyType keyType) {
        return keyType._clazz.isInstance(key);
    }

    boolean isValidValue(V value, ValueType valueType, ArrayType arrayType) {
        if (value == null) {
            return false;
        }
        switch (arrayType) {
            case None: {
                return valueType._clazz.isInstance(value);
            }
            case Array: {
                return valueType._arrayClazz.isInstance(value);
            }
            case PrimitiveArray: {
                return valueType._primitiveArrayClazz.isInstance(value);
            }
        }
        return false;
    }

    public final AutoBuffer write_impl(AutoBuffer ab) {
        this._write_lock = true;
        try {
            if (this.map().size() == 0) {
                AutoBuffer autoBuffer = ab.put1(-1);
                return autoBuffer;
            }
            Map.Entry<K, V> entry = this.map().entrySet().iterator().next();
            K key = entry.getKey();
            V val = entry.getValue();
            assert (key != null && val != null);
            byte mode = IcedHashMapBase.getMode(this.getKeyType(key), this.getValueType(val), this.getArrayType(val));
            ab.put1(mode);
            this.writeMap(ab, mode);
            switch (IcedHashMapBase.keyType(mode)) {
                case String: {
                    AutoBuffer autoBuffer = ab.putStr(null);
                    return autoBuffer;
                }
            }
            AutoBuffer autoBuffer = ab.put(null);
            return autoBuffer;
        }
        catch (Throwable t2) {
            throw H2O.fail("Iced hash map serialization failed!" + t2.toString() + ", msg = " + t2.getMessage(), t2);
        }
        finally {
            this._write_lock = false;
        }
    }

    protected abstract Map<K, V> init();

    protected boolean writeable() {
        return !this._write_lock;
    }

    protected void writeMap(AutoBuffer ab, byte mode) {
        KeyType keyType = IcedHashMapBase.keyType(mode);
        ValueType valueType = IcedHashMapBase.valueType(mode);
        ArrayType arrayType = IcedHashMapBase.arrayType(mode);
        for (Map.Entry<K, V> e2 : this.map().entrySet()) {
            K key = e2.getKey();
            assert (key != null);
            V val = e2.getValue();
            assert (val != null);
            this.writeKey(ab, keyType, key);
            this.writeValue(ab, valueType, arrayType, val);
        }
    }

    protected void writeKey(AutoBuffer ab, KeyType keyType, K key) {
        switch (keyType) {
            case String: {
                ab.putStr((String)key);
                break;
            }
            case Freezable: {
                ab.put((Freezable)key);
            }
        }
    }

    protected void writeValue(AutoBuffer ab, ValueType valueType, ArrayType arrayType, V value) {
        block0 : switch (arrayType) {
            case None: {
                switch (valueType) {
                    case String: {
                        ab.putStr((String)value);
                        break;
                    }
                    case Freezable: {
                        ab.put((Freezable)value);
                        break;
                    }
                    case Boolean: {
                        ab.put1((Boolean)value != false ? 1 : 0);
                        break;
                    }
                    case Integer: {
                        ab.put4((Integer)value);
                        break;
                    }
                    case Long: {
                        ab.put8((Long)value);
                        break;
                    }
                    case Float: {
                        ab.put4f(((Float)value).floatValue());
                        break;
                    }
                    case Double: {
                        ab.put8d((Double)value);
                    }
                }
                break;
            }
            case Array: {
                switch (valueType) {
                    case String: {
                        ab.putAStr((String[])value);
                        break;
                    }
                    case Freezable: {
                        ab.putA((Freezable[])value);
                        break;
                    }
                    case Boolean: {
                        ab.putA1(IcedHashMapBase.bools2bytes(ArrayUtils.toPrimitive((Boolean[])((Boolean[])value))));
                        break;
                    }
                    case Integer: {
                        ab.putA4(ArrayUtils.toPrimitive((Integer[])((Integer[])value)));
                        break;
                    }
                    case Long: {
                        ab.putA8(ArrayUtils.toPrimitive((Long[])((Long[])value)));
                        break;
                    }
                    case Float: {
                        ab.putA4f(ArrayUtils.toPrimitive((Float[])((Float[])value)));
                        break;
                    }
                    case Double: {
                        ab.putA8d(ArrayUtils.toPrimitive((Double[])((Double[])value)));
                    }
                }
                break;
            }
            case PrimitiveArray: {
                switch (valueType) {
                    case Boolean: {
                        ab.putA1(IcedHashMapBase.bools2bytes((boolean[])value));
                        break block0;
                    }
                    case Integer: {
                        ab.putA4((int[])value);
                        break block0;
                    }
                    case Long: {
                        ab.putA8((long[])value);
                        break block0;
                    }
                    case Float: {
                        ab.putA4f((float[])value);
                        break block0;
                    }
                    case Double: {
                        ab.putA8d((double[])value);
                    }
                }
            }
        }
    }

    protected K readKey(AutoBuffer ab, KeyType keyType) {
        switch (keyType) {
            case String: {
                return (K)ab.getStr();
            }
            case Freezable: {
                return (K)ab.get();
            }
        }
        return null;
    }

    protected V readValue(AutoBuffer ab, ValueType valueType, ArrayType arrayType) {
        switch (arrayType) {
            case None: {
                switch (valueType) {
                    case String: {
                        return (V)ab.getStr();
                    }
                    case Freezable: {
                        return (V)ab.get();
                    }
                    case Boolean: {
                        return (V)Boolean.valueOf(ab.get1() == 1);
                    }
                    case Integer: {
                        return (V)Integer.valueOf(ab.get4());
                    }
                    case Long: {
                        return (V)Long.valueOf(ab.get8());
                    }
                    case Float: {
                        return (V)Float.valueOf(ab.get4f());
                    }
                    case Double: {
                        return (V)Double.valueOf(ab.get8d());
                    }
                }
                return null;
            }
            case Array: {
                switch (valueType) {
                    case String: {
                        return (V)ab.getAStr();
                    }
                    case Freezable: {
                        return (V)ab.getA(Freezable.class);
                    }
                    case Boolean: {
                        return (V)ArrayUtils.toObject((boolean[])IcedHashMapBase.bytes2bools(ab.getA1()));
                    }
                    case Integer: {
                        return (V)ArrayUtils.toObject((int[])ab.getA4());
                    }
                    case Long: {
                        return (V)ArrayUtils.toObject((long[])ab.getA8());
                    }
                    case Float: {
                        return (V)ArrayUtils.toObject((float[])ab.getA4f());
                    }
                    case Double: {
                        return (V)ArrayUtils.toObject((double[])ab.getA8d());
                    }
                }
                return null;
            }
            case PrimitiveArray: {
                switch (valueType) {
                    case Boolean: {
                        return (V)IcedHashMapBase.bytes2bools(ab.getA1());
                    }
                    case Integer: {
                        return (V)ab.getA4();
                    }
                    case Long: {
                        return (V)ab.getA8();
                    }
                    case Float: {
                        return (V)ab.getA4f();
                    }
                    case Double: {
                        return (V)ab.getA8d();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public final IcedHashMapBase read_impl(AutoBuffer ab) {
        try {
            K key;
            assert (this.map() == null || this.map().isEmpty());
            Map<K, V> map = this.init();
            byte mode = ab.get1();
            if (mode == -1) {
                return this;
            }
            KeyType keyType = IcedHashMapBase.keyType(mode);
            ValueType valueType = IcedHashMapBase.valueType(mode);
            ArrayType arrayType = IcedHashMapBase.arrayType(mode);
            while ((key = this.readKey(ab, keyType)) != null) {
                V val = this.readValue(ab, valueType, arrayType);
                map.put(key, val);
            }
            return this;
        }
        catch (Throwable t2) {
            if (null == t2.getCause()) {
                throw H2O.fail("IcedHashMap deserialization failed! + " + t2.toString() + ", msg = " + t2.getMessage() + ", cause: null", t2);
            }
            throw H2O.fail("IcedHashMap deserialization failed! + " + t2.toString() + ", msg = " + t2.getMessage() + ", cause: " + t2.getCause().toString() + ", cause msg: " + t2.getCause().getMessage() + ", cause stacktrace: " + Arrays.toString(t2.getCause().getStackTrace()));
        }
    }

    public final IcedHashMapBase readJSON_impl(AutoBuffer ab) {
        throw H2O.unimpl();
    }

    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        boolean first = true;
        for (Map.Entry<K, V> entry : this.map().entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            KeyType keyType = this.getKeyType(key);
            assert (keyType == KeyType.String) : "JSON format supports only String keys";
            ValueType valueType = this.getValueType(value);
            ArrayType arrayType = this.getArrayType(value);
            if (first) {
                first = false;
            } else {
                ab.put1(44).put1(32);
            }
            String name = (String)key;
            block0 : switch (arrayType) {
                case None: {
                    switch (valueType) {
                        case String: {
                            ab.putJSONStr(name, (String)value);
                            break block0;
                        }
                        case Freezable: {
                            ab.putJSON(name, (Freezable)value);
                            break block0;
                        }
                        case Boolean: {
                            ab.putJSONStrUnquoted(name, Boolean.toString((Boolean)value));
                            break block0;
                        }
                        case Integer: {
                            ab.putJSON4(name, (Integer)value);
                            break block0;
                        }
                        case Long: {
                            ab.putJSON8(name, (Long)value);
                            break block0;
                        }
                        case Float: {
                            ab.putJSON4f(name, ((Float)value).floatValue());
                            break block0;
                        }
                        case Double: {
                            ab.putJSON8d(name, (Double)value);
                        }
                    }
                    break;
                }
                case Array: {
                    switch (valueType) {
                        case String: {
                            ab.putJSONAStr(name, (String[])value);
                            break block0;
                        }
                        case Freezable: {
                            ab.putJSONA(name, (Freezable[])value);
                            break block0;
                        }
                        case Boolean: {
                            ab.putJSONStrUnquoted(name, Arrays.toString(ArrayUtils.toPrimitive((Boolean[])((Boolean[])value))));
                            break block0;
                        }
                        case Integer: {
                            ab.putJSONA4(name, ArrayUtils.toPrimitive((Integer[])((Integer[])value)));
                            break block0;
                        }
                        case Long: {
                            ab.putJSONA8(name, ArrayUtils.toPrimitive((Long[])((Long[])value)));
                            break block0;
                        }
                        case Float: {
                            ab.putJSONA4f(name, ArrayUtils.toPrimitive((Float[])((Float[])value)));
                            break block0;
                        }
                        case Double: {
                            ab.putJSONA8d(name, ArrayUtils.toPrimitive((Double[])((Double[])value)));
                        }
                    }
                    break;
                }
                case PrimitiveArray: {
                    switch (valueType) {
                        case Boolean: {
                            ab.putJSONStrUnquoted(name, Arrays.toString((boolean[])value));
                            break block0;
                        }
                        case Integer: {
                            ab.putJSONA4(name, (int[])value);
                            break block0;
                        }
                        case Long: {
                            ab.putJSONA8(name, (long[])value);
                            break block0;
                        }
                        case Float: {
                            ab.putJSONA4f(name, (float[])value);
                            break block0;
                        }
                        case Double: {
                            ab.putJSONA8d(name, (double[])value);
                        }
                    }
                }
            }
        }
        return ab;
    }

    private static byte[] bools2bytes(boolean[] bools) {
        byte[] bytes = new byte[bools.length];
        for (int i2 = 0; i2 < bools.length; ++i2) {
            bytes[i2] = bools[i2] ? (byte)1 : 0;
        }
        return bytes;
    }

    private static boolean[] bytes2bools(byte[] bytes) {
        boolean[] bools = new boolean[bytes.length];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            bools[i2] = bytes[i2] == 1;
        }
        return bools;
    }

    public static enum ArrayType {
        None,
        Array,
        PrimitiveArray;

    }

    public static enum ValueType {
        String(String.class),
        Freezable(Freezable.class),
        Boolean(Boolean.class, java.lang.Boolean.TYPE),
        Integer(Integer.class, java.lang.Integer.TYPE),
        Long(Long.class, java.lang.Long.TYPE),
        Float(Float.class, java.lang.Float.TYPE),
        Double(Double.class, java.lang.Double.TYPE);

        Class _clazz;
        Class _arrayClazz;
        Class _primitiveArrayClazz;

        private ValueType(Class clazz) {
            this(clazz, Void.class);
        }

        private ValueType(Class clazz, Class primitiveClazz) {
            this._clazz = clazz;
            this._arrayClazz = Array.newInstance(this._clazz, 0).getClass();
            this._primitiveArrayClazz = Array.newInstance(primitiveClazz, 0).getClass();
        }
    }

    public static enum KeyType {
        String(String.class),
        Freezable(Freezable.class);

        Class _clazz;

        private KeyType(Class clazz) {
            this._clazz = clazz;
        }
    }
}

