/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import water.AutoBuffer;
import water.Freezable;
import water.H2O;
import water.Iced;
import water.nbhm.NonBlockingHashMap;

public class IcedHashSet<V extends Freezable<V>>
extends Iced<IcedHashSet<V>>
implements Set<V>,
Cloneable,
Serializable {
    private volatile transient boolean _write_lock;
    private transient NonBlockingHashMap<V, V> _map;

    public IcedHashSet() {
        this.init();
    }

    private Map<V, V> init() {
        this._map = this.makeBackingMap();
        return this._map;
    }

    private NonBlockingHashMap<V, V> makeBackingMap() {
        return new NonBlockingHashMap();
    }

    public V addIfAbsent(V value) {
        assert (!this._write_lock);
        return (V)((Freezable)this._map.putIfAbsent(value, value));
    }

    public V get(V value) {
        assert (!this._write_lock);
        return (V)((Freezable)this._map.getk(value));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean contains(Object value) {
        return this._map.containsKey(value);
    }

    @Override
    public Iterator<V> iterator() {
        return this._map.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this._map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        Objects.requireNonNull(a2);
        return this._map.values().toArray(a2);
    }

    @Override
    public boolean add(V v2) {
        assert (!this._write_lock);
        return this._map.putIfAbsent(v2, v2) == null;
    }

    @Override
    public boolean remove(Object o2) {
        assert (!this._write_lock);
        return this._map.remove(o2, o2);
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        return this._map.keySet().containsAll(c2);
    }

    @Override
    public boolean addAll(Collection<? extends V> c2) {
        assert (!this._write_lock);
        boolean added = false;
        for (Freezable item : c2) {
            added |= this._map.putIfAbsent((V)item, (V)item) == null;
        }
        return added;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        throw new UnsupportedOperationException("Operation retainAll is not yet supported on IcedHashSet");
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        throw new UnsupportedOperationException("Operation removeAll is not yet supported on IcedHashSet");
    }

    @Override
    public void clear() {
        assert (!this._write_lock);
        this._map.clear();
    }

    private void writeMap(AutoBuffer ab) {
        Object[] kvs = this._map.raw_array();
        for (int i2 = 2; i2 < kvs.length; i2 += 2) {
            if (!(kvs[i2 + 1] instanceof Iced)) continue;
            ab.put((Freezable)kvs[i2 + 1]);
        }
    }

    public final AutoBuffer write_impl(AutoBuffer ab) {
        this._write_lock = true;
        try {
            if (this._map.size() == 0) {
                AutoBuffer autoBuffer = ab.put1(0);
                return autoBuffer;
            }
            ab.put1(1);
            this.writeMap(ab);
            AutoBuffer autoBuffer = ab.put(null);
            return autoBuffer;
        }
        catch (Exception e2) {
            throw new RuntimeException("IcedHashSet serialization failed!", e2);
        }
        finally {
            this._write_lock = false;
        }
    }

    public final IcedHashSet read_impl(AutoBuffer ab) {
        try {
            Object val;
            assert (this._map == null || this._map.isEmpty());
            Map map = this.init();
            if (ab.get1() == 0) {
                return this;
            }
            while ((val = ab.get()) != null) {
                map.put(val, val);
            }
            return this;
        }
        catch (Exception e2) {
            throw new RuntimeException("IcedHashSet deserialization failed!", e2);
        }
    }

    public final IcedHashSet readJSON_impl(AutoBuffer ab) {
        throw H2O.unimpl();
    }

    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        boolean first = true;
        for (Freezable value : this._map.values()) {
            if (!first) {
                ab.put1(44).put1(32);
            } else {
                first = false;
            }
            if (value == null) continue;
            ab.putJSON(value);
        }
        return ab;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        IcedHashSet that = (IcedHashSet)o2;
        return this._map != null ? this._map.equals(that._map) : that._map == null;
    }

    @Override
    public int hashCode() {
        return this._map != null ? this._map.hashCode() : 0;
    }
}

