/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import water.H2O;
import water.Iced;
import water.util.Log;
import water.util.ProfileCollectorTask;

public class JProfile
extends Iced {
    public final String node_name;
    public final long timestamp;
    public final int depth;
    public ProfileSummary[] nodes;

    public JProfile(int d2) {
        this.depth = d2;
        this.node_name = H2O.getIpPortString();
        this.timestamp = System.currentTimeMillis();
    }

    public JProfile execImpl(boolean print) {
        int i2;
        ProfileCollectorTask.NodeProfile[] profiles = ((ProfileCollectorTask)new ProfileCollectorTask((int)this.depth).doAllNodes())._result;
        this.nodes = new ProfileSummary[H2O.CLOUD.size()];
        for (i2 = 0; i2 < this.nodes.length; ++i2) {
            assert (profiles[i2] != null);
            this.nodes[i2] = new ProfileSummary(H2O.CLOUD._memary[i2].toString(), profiles[i2]);
        }
        if (!print) {
            return this;
        }
        for (i2 = 0; i2 < this.nodes.length; ++i2) {
            Log.info(this.nodes[i2].name);
            for (int j2 = 0; j2 < this.nodes[i2].profile.counts.length; ++j2) {
                Log.info(this.nodes[i2].profile.counts[j2]);
                Log.info(this.nodes[i2].profile.stacktraces[j2]);
            }
        }
        return this;
    }

    public static class ProfileSummary
    extends Iced {
        public final String name;
        public final ProfileCollectorTask.NodeProfile profile;

        public ProfileSummary(String name, ProfileCollectorTask.NodeProfile profile) {
            this.name = name;
            this.profile = profile;
        }
    }
}

