/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Objects;
import water.Iced;
import water.api.Schema;
import water.util.JSONUtils;
import water.util.PojoUtils;

public class JSONValue<V>
extends Iced {
    protected String _json;
    protected Class<V> _clazz;

    public static <V> JSONValue<V> fromValue(V v2) {
        return new JSONValue(JSONUtils.toJSON(v2), v2.getClass());
    }

    public JSONValue(String json) {
        this(json, null);
    }

    public JSONValue(String json, Class<V> clazz) {
        this._json = json;
        this._clazz = clazz;
    }

    public V value() {
        return this.valueAs(this._clazz);
    }

    public <T> T valueAs(Class<T> clazz) {
        if (clazz == null) {
            return (T)JSONUtils.parse(this._json);
        }
        return JSONUtils.parse(this._json, clazz);
    }

    public <T extends Iced, S extends Schema<T, S>> T valueAs(Class<T> clazz, Class<S> schema) {
        return ((Schema)this.valueAsSchema(schema)).createAndFillImpl();
    }

    public <T extends Iced, S extends Schema<T, S>> T[] valueAsArray(Class<T[]> clazz, Class<S[]> schema) {
        Schema[] ss = this.valueAsSchemas(schema);
        Class<?> tClazz = clazz.getComponentType();
        Iced[] ts = (Iced[])Array.newInstance(tClazz, ss.length);
        for (int i2 = 0; i2 < ss.length; ++i2) {
            ts[i2] = ss[i2].createAndFillImpl();
        }
        return ts;
    }

    public <S extends Schema> S valueAsSchema(Class<S> schema) {
        Object s2;
        if (Schema.AutoParseable.class.isAssignableFrom(schema)) {
            s2 = (Schema)this.valueAs(schema);
        } else {
            s2 = Schema.newInstance(schema);
            PojoUtils.fillFromJson(s2, this._json);
        }
        return s2;
    }

    public <S extends Schema> S[] valueAsSchemas(Class<S[]> schema) {
        Schema[] ss;
        Class<?> sClazz = schema.getComponentType();
        if (Schema.AutoParseable.class.isAssignableFrom(sClazz)) {
            ss = (Schema[])this.valueAs(schema);
        } else {
            Map[] maps = this.valueAs(Map[].class);
            ss = (Schema[])Array.newInstance(sClazz, maps.length);
            for (int i2 = 0; i2 < ss.length; ++i2) {
                ss[i2] = JSONValue.fromValue(maps[i2]).valueAsSchema(sClazz);
            }
        }
        return ss;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        JSONValue jsonValue = (JSONValue)o2;
        return Objects.equals(this._json, jsonValue._json) && Objects.equals(this._clazz, jsonValue._clazz);
    }

    public int hashCode() {
        return Objects.hash(this._json, this._clazz);
    }
}

