/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import water.H2O;
import water.util.LoggerBackend;
import water.util.StringUtils;

public abstract class Log {
    public static final byte FATAL = 0;
    public static final byte ERRR = 1;
    public static final byte WARN = 2;
    public static final byte INFO = 3;
    public static final byte DEBUG = 4;
    public static final byte TRACE = 5;
    public static final String[] LVLS = new String[]{"FATAL", "ERRR", "WARN", "INFO", "DEBUG", "TRACE"};
    private static int _level = 3;
    private static boolean _quiet = false;
    private static Logger _logger = null;
    private static boolean _bufferMessages = true;
    private static String _logDir = null;
    private static String _maxLogFileSize = "3MB";
    private static ArrayList<BufferedMsg> INIT_MSGS = new ArrayList();

    public static byte valueOf(String slvl) {
        if (slvl == null) {
            return -1;
        }
        if ((slvl = slvl.toLowerCase()).startsWith("fatal")) {
            return 0;
        }
        if (slvl.startsWith("err")) {
            return 1;
        }
        if (slvl.startsWith("warn")) {
            return 2;
        }
        if (slvl.startsWith("info")) {
            return 3;
        }
        if (slvl.startsWith("debug")) {
            return 4;
        }
        if (slvl.startsWith("trace")) {
            return 5;
        }
        return -1;
    }

    public static void init(String sLvl, boolean quiet, String maxLogFileSize) {
        byte lvl = Log.valueOf(sLvl);
        if (lvl != -1) {
            _level = lvl;
        }
        _quiet = quiet;
        _logger = null;
        if (maxLogFileSize != null) {
            _maxLogFileSize = maxLogFileSize;
        }
    }

    public static void notifyAboutNetworkingInitialized() {
        _bufferMessages = false;
        assert (H2O.SELF_ADDRESS != null && H2O.H2O_PORT != 0);
    }

    public static void notifyAboutProcessExiting() {
        Log.flushBufferedMessages();
        if (_quiet) {
            _quiet = false;
            _logger = null;
        }
        INIT_MSGS = null;
    }

    public static void setLogLevel(String level, boolean quiet) {
        Log.init(level, quiet, null);
    }

    public static void setLogLevel(String level) {
        Log.setLogLevel(level, true);
    }

    public static void trace(Object ... objs) {
        Log.log(5, objs);
    }

    public static void debug(Object ... objs) {
        Log.log(4, objs);
    }

    public static void info(Object ... objs) {
        Log.log(3, objs);
    }

    public static void warn(Object ... objs) {
        Log.log(2, objs);
    }

    public static void err(Object ... objs) {
        Log.log(1, objs);
    }

    public static void fatal(Object ... objs) {
        Log.log(0, objs);
    }

    public static void log(int level, Object ... objs) {
        Log.write(level, objs);
    }

    public static RuntimeException throwErr(Throwable e2) {
        Log.err(e2);
        throw e2 instanceof RuntimeException ? (RuntimeException)e2 : new RuntimeException(e2);
    }

    private static void write(int lvl, Object[] objs) {
        Log.write0(lvl, objs);
    }

    private static void write0(int lvl, Object[] objs) {
        StringBuilder msgBuff = new StringBuilder();
        Throwable t2 = null;
        for (int i2 = 0; i2 < objs.length - 1; ++i2) {
            msgBuff.append(objs[i2]);
        }
        if (objs.length > 0 && objs[objs.length - 1] instanceof Throwable) {
            t2 = (Throwable)objs[objs.length - 1];
        } else if (objs.length > 0) {
            msgBuff.append(objs[objs.length - 1]);
        }
        String msg = msgBuff.toString();
        if (_bufferMessages) {
            INIT_MSGS.add(new BufferedMsg(lvl, msg, t2));
            return;
        }
        Log.flushBufferedMessages();
        Log.write0(lvl, msg, t2);
    }

    private static void write0(int lvl, String s2, Throwable t2) {
        Logger log;
        Logger logger = log = _logger != null ? _logger : Log.createLog4j();
        if (s2.contains("\n")) {
            for (String line : s2.split("\n")) {
                log.log((Priority)LoggerBackend.L4J_LVLS[lvl], (Object)line);
            }
            if (t2 != null) {
                log.log((Priority)LoggerBackend.L4J_LVLS[lvl], (Object)t2);
            }
        } else {
            log.log((Priority)LoggerBackend.L4J_LVLS[lvl], (Object)s2, t2);
        }
    }

    private static List<BufferedMsg> consumeBufferedMessages() {
        ArrayList<BufferedMsg> buff = null;
        if (INIT_MSGS != null) {
            buff = INIT_MSGS;
            INIT_MSGS = null;
        }
        return buff;
    }

    public static void flushBufferedMessages() {
        List<BufferedMsg> buff = Log.consumeBufferedMessages();
        if (buff != null) {
            for (BufferedMsg m4 : buff) {
                Log.write0(m4.lvl, m4.msg, m4.t);
            }
        }
    }

    public static void flushBufferedMessagesToStdout() {
        List<BufferedMsg> buff = Log.consumeBufferedMessages();
        if (buff != null) {
            for (BufferedMsg m4 : buff) {
                System.out.println(m4.msg);
                if (m4.t == null) continue;
                m4.t.printStackTrace();
            }
        }
    }

    public static int getLogLevel() {
        return _level;
    }

    public static boolean isLoggingFor(int level) {
        if (level == -1) {
            return false;
        }
        return _level >= level;
    }

    public static boolean isLoggingFor(String strLevel) {
        byte level = Log.valueOf(strLevel);
        return Log.isLoggingFor(level);
    }

    public static String getLogDir() {
        if (_logDir == null) {
            throw new RuntimeException("LOG_DIR not yet defined");
        }
        return _logDir;
    }

    private static String getLogFileNamePrefix() {
        if (H2O.SELF_ADDRESS == null) {
            throw new RuntimeException("H2O.SELF_ADDRESS not yet defined");
        }
        if (H2O.H2O_PORT == 0) {
            throw new RuntimeException("H2O.H2O_PORT is not yet determined");
        }
        String ip = H2O.SELF_ADDRESS.getHostAddress();
        int port = H2O.API_PORT;
        String portString = Integer.toString(port);
        return "h2o_" + ip + "_" + portString;
    }

    private static File determineLogDir() {
        File dir;
        if (H2O.ARGS.log_dir != null) {
            dir = new File(H2O.ARGS.log_dir);
        } else {
            boolean windowsPath = H2O.ICE_ROOT.toString().matches("^[a-zA-Z]:.*");
            dir = windowsPath ? new File(H2O.ICE_ROOT.toString()) : (H2O.ICE_ROOT.getScheme() == null || "file".equals(H2O.ICE_ROOT.getScheme()) ? new File(H2O.ICE_ROOT.getPath()) : new File(H2O.DEFAULT_ICE_ROOT()));
            dir = new File(dir, "h2ologs");
        }
        return dir;
    }

    public static String getLogFileName(String level) {
        return Log.getLogFileNamePrefix() + Log.getLogFileNameSuffix(level);
    }

    private static String getLogFileNameSuffix(String level) {
        switch (level) {
            case "trace": {
                return "-1-trace.log";
            }
            case "debug": {
                return "-2-debug.log";
            }
            case "info": {
                return "-3-info.log";
            }
            case "warn": {
                return "-4-warn.log";
            }
            case "error": {
                return "-5-error.log";
            }
            case "fatal": {
                return "-6-fatal.log";
            }
            case "httpd": {
                return "-httpd.log";
            }
        }
        throw new RuntimeException("Unknown level " + level);
    }

    public static String getLogFilePath(String level) {
        return Log.getLogDir() + File.separator + Log.getLogFileName(level);
    }

    private static String getHostPortPid() {
        String host = H2O.SELF_ADDRESS.getHostAddress();
        return StringUtils.fixedLength(host + ":" + H2O.API_PORT + " ", 22) + StringUtils.fixedLength(H2O.PID + " ", 6);
    }

    private static synchronized Logger createLog4j() {
        if (_logger == null) {
            _logDir = Log.determineLogDir().toString();
            LoggerBackend lb = new LoggerBackend();
            lb._launchedWithHadoopJar = H2O.ARGS.launchedWithHadoopJar();
            lb._haveInheritedLog4jConfiguration = H2O.haveInheritedLog4jConfiguration();
            lb._prefix = Log.getHostPortPid();
            lb._maxLogFileSize = _maxLogFileSize;
            lb._level = _level;
            lb._getLogFilePath = Log::getLogFilePath;
            Logger logger = lb.createLog4j();
            if (logger == null) {
                H2O.exit(1);
                throw new IllegalStateException("Shouldn't reach this - exit should exit the application");
            }
            _logger = logger;
        }
        return _logger;
    }

    public static void ignore(Throwable e2) {
        Log.ignore(e2, "[h2o] Problem ignored: ");
    }

    public static void ignore(Throwable e2, String msg) {
        Log.ignore(e2, msg, true);
    }

    public static void ignore(Throwable e2, String msg, boolean printException) {
        Log.debug(msg + (printException ? e2.toString() : ""));
    }

    public static void POST(int n2, String s2) {
        System.out.println("POST " + n2 + ": " + s2);
    }

    public static void POST(int n2, Exception e2) {
        StackTraceElement[] els;
        if (e2.getMessage() != null) {
            Log.POST(n2, e2.getMessage());
        }
        Log.POST(n2, e2.toString());
        for (StackTraceElement el : els = e2.getStackTrace()) {
            Log.POST(n2, el.toString());
        }
    }

    private static class BufferedMsg {
        private final int lvl;
        private final String msg;
        private final Throwable t;

        BufferedMsg(int l2, String m4, Throwable t2) {
            this.lvl = l2;
            this.msg = m4;
            this.t = t2;
        }
    }
}

