/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public abstract class LogArchiveWriter
implements Closeable {
    final OutputStream _os;

    LogArchiveWriter(OutputStream os2) {
        this._os = os2;
    }

    public abstract void putNextEntry(ArchiveEntry var1) throws IOException;

    public abstract void closeEntry() throws IOException;

    public void write(byte[] b2, int off, int len) throws IOException {
        this._os.write(b2, off, len);
    }

    public final void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void close() throws IOException {
        this._os.close();
    }

    public static class ArchiveEntry {
        final String _name;
        final long _time;

        public ArchiveEntry(String name, Date date) {
            this(name, date.getTime());
        }

        ArchiveEntry(String name, long time) {
            this._name = name;
            this._time = time;
        }

        public String toString() {
            return this._name + " (" + new Date(this._time) + ")";
        }
    }
}

