/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import java.util.function.Function;
import org.apache.log4j.H2OPropertyConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LoggerBackend {
    public static final Level[] L4J_LVLS = new Level[]{Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};
    public int _level;
    public String _prefix;
    public String _maxLogFileSize;
    public boolean _launchedWithHadoopJar;
    public boolean _haveInheritedLog4jConfiguration;
    public Function<String, String> _getLogFilePath;

    public Logger createLog4j() {
        String h2oLog4jConfiguration = System.getProperty("h2o.log4j.configuration");
        if (h2oLog4jConfiguration != null) {
            if (new File(h2oLog4jConfiguration).exists()) {
                PropertyConfigurator.configure((String)h2oLog4jConfiguration);
            } else {
                URL confUrl = LoggerBackend.class.getClassLoader().getResource(h2oLog4jConfiguration);
                if (confUrl != null) {
                    PropertyConfigurator.configure((URL)confUrl);
                }
            }
        } else {
            Properties p2 = new Properties();
            try {
                this.setLog4jProperties(p2);
            }
            catch (Exception e2) {
                System.err.println("ERROR: failed in createLog4j, exiting now.");
                e2.printStackTrace();
                return null;
            }
            if (!this._launchedWithHadoopJar && this._haveInheritedLog4jConfiguration) {
                H2OPropertyConfigurator.configure((Properties)p2);
            } else {
                PropertyConfigurator.configure((Properties)p2);
            }
        }
        return Logger.getLogger((String)"water.default");
    }

    private void setLog4jProperties(Properties p2) {
        String patternTail = this._prefix + " %10.10t %5.5p %c: %m%n";
        String pattern = "%d{MM-dd HH:mm:ss.SSS} " + patternTail;
        p2.setProperty("log4j.rootLogger", L4J_LVLS[this._level] + ", console");
        String appendersReferences = ", R1, R2, R3, R4, R5, R6";
        String appenders = L4J_LVLS[this._level] + appendersReferences;
        for (String packageName : new String[]{"water", "ai.h2o", "hex"}) {
            p2.setProperty("log4j.logger." + packageName, appenders);
            p2.setProperty("log4j.logger.additivity." + packageName, "false");
        }
        p2.setProperty("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
        p2.setProperty("log4j.appender.console.Threshold", L4J_LVLS[this._level].toString());
        p2.setProperty("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
        p2.setProperty("log4j.appender.console.layout.ConversionPattern", pattern);
        p2.setProperty("log4j.appender.R1", "org.apache.log4j.RollingFileAppender");
        p2.setProperty("log4j.appender.R1.Threshold", "TRACE");
        p2.setProperty("log4j.appender.R1.File", this._getLogFilePath.apply("trace"));
        p2.setProperty("log4j.appender.R1.MaxFileSize", "1MB");
        p2.setProperty("log4j.appender.R1.MaxBackupIndex", "3");
        p2.setProperty("log4j.appender.R1.layout", "org.apache.log4j.PatternLayout");
        p2.setProperty("log4j.appender.R1.layout.ConversionPattern", pattern);
        p2.setProperty("log4j.appender.R2", "org.apache.log4j.RollingFileAppender");
        p2.setProperty("log4j.appender.R2.Threshold", "DEBUG");
        p2.setProperty("log4j.appender.R2.File", this._getLogFilePath.apply("debug"));
        p2.setProperty("log4j.appender.R2.MaxFileSize", this._maxLogFileSize);
        p2.setProperty("log4j.appender.R2.MaxBackupIndex", "3");
        p2.setProperty("log4j.appender.R2.layout", "org.apache.log4j.PatternLayout");
        p2.setProperty("log4j.appender.R2.layout.ConversionPattern", pattern);
        p2.setProperty("log4j.appender.R3", "org.apache.log4j.RollingFileAppender");
        p2.setProperty("log4j.appender.R3.Threshold", "INFO");
        p2.setProperty("log4j.appender.R3.File", this._getLogFilePath.apply("info"));
        p2.setProperty("log4j.appender.R3.MaxFileSize", this._maxLogFileSize);
        p2.setProperty("log4j.appender.R3.MaxBackupIndex", "3");
        p2.setProperty("log4j.appender.R3.layout", "org.apache.log4j.PatternLayout");
        p2.setProperty("log4j.appender.R3.layout.ConversionPattern", pattern);
        p2.setProperty("log4j.appender.R4", "org.apache.log4j.RollingFileAppender");
        p2.setProperty("log4j.appender.R4.Threshold", "WARN");
        p2.setProperty("log4j.appender.R4.File", this._getLogFilePath.apply("warn"));
        p2.setProperty("log4j.appender.R4.MaxFileSize", "256KB");
        p2.setProperty("log4j.appender.R4.MaxBackupIndex", "3");
        p2.setProperty("log4j.appender.R4.layout", "org.apache.log4j.PatternLayout");
        p2.setProperty("log4j.appender.R4.layout.ConversionPattern", pattern);
        p2.setProperty("log4j.appender.R5", "org.apache.log4j.RollingFileAppender");
        p2.setProperty("log4j.appender.R5.Threshold", "ERROR");
        p2.setProperty("log4j.appender.R5.File", this._getLogFilePath.apply("error"));
        p2.setProperty("log4j.appender.R5.MaxFileSize", "256KB");
        p2.setProperty("log4j.appender.R5.MaxBackupIndex", "3");
        p2.setProperty("log4j.appender.R5.layout", "org.apache.log4j.PatternLayout");
        p2.setProperty("log4j.appender.R5.layout.ConversionPattern", pattern);
        p2.setProperty("log4j.appender.R6", "org.apache.log4j.RollingFileAppender");
        p2.setProperty("log4j.appender.R6.Threshold", "FATAL");
        p2.setProperty("log4j.appender.R6.File", this._getLogFilePath.apply("fatal"));
        p2.setProperty("log4j.appender.R6.MaxFileSize", "256KB");
        p2.setProperty("log4j.appender.R6.MaxBackupIndex", "3");
        p2.setProperty("log4j.appender.R6.layout", "org.apache.log4j.PatternLayout");
        p2.setProperty("log4j.appender.R6.layout.ConversionPattern", pattern);
        p2.setProperty("log4j.logger.water.api.RequestServer", "TRACE, HTTPD");
        p2.setProperty("log4j.additivity.water.api.RequestServer", "false");
        p2.setProperty("log4j.appender.HTTPD", "org.apache.log4j.RollingFileAppender");
        p2.setProperty("log4j.appender.HTTPD.Threshold", "TRACE");
        p2.setProperty("log4j.appender.HTTPD.File", this._getLogFilePath.apply("httpd"));
        p2.setProperty("log4j.appender.HTTPD.MaxFileSize", "1MB");
        p2.setProperty("log4j.appender.HTTPD.MaxBackupIndex", "3");
        p2.setProperty("log4j.appender.HTTPD.layout", "org.apache.log4j.PatternLayout");
        p2.setProperty("log4j.appender.HTTPD.layout.ConversionPattern", "%d{ISO8601} " + patternTail);
        p2.setProperty("log4j.logger.org.apache.http", "WARN" + appendersReferences);
        p2.setProperty("log4j.logger.com.amazonaws", "WARN" + appendersReferences);
        p2.setProperty("log4j.logger.org.apache.hadoop", "WARN" + appendersReferences);
        p2.setProperty("log4j.logger.org.jets3t.service", "WARN" + appendersReferences);
        p2.setProperty("log4j.logger.org.reflections.Reflections", "ERROR" + appendersReferences);
        p2.setProperty("log4j.logger.com.brsanthu.googleanalytics", "ERROR" + appendersReferences);
        p2.setProperty("log4j.logger.org.apache.hadoop.util.NativeCodeLoader", "ERROR");
    }
}

