/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import water.util.ArrayUtils;
import water.util.OSUtils;

public class NetworkUtils {
    public static byte[] GOOGLE_DNS_IPV4 = new byte[]{8, 8, 8, 8};
    public static byte[] GOOGLE_DNS_IPV6 = ArrayUtils.toByteArray(new int[]{32, 1, 72, 96, 72, 96, 0, 0, 0, 0, 0, 0, 0, 0, 136, 136});
    private static String H2O_SYSTEM_SCOPE_PARAM = "sys.ai.h2o.network.ipv6.scope";
    private static String H2O_SYSTEM_LOCAL_IP_PING_TIMEOUT = "sys.ai.h2o.network.ip.ping.timeout";
    public static long SCOPE_IFACE_LOCAL = 0x1000000000000L;
    public static long SCOPE_LINK_LOCAL = 0x2000000000000L;
    public static long SCOPE_SITE_LOCAL = 0x5000000000000L;
    public static long SCOPE_ORG_LOCAL = 0x8000000000000L;
    public static long SCOPE_GLOBAL_LOCAL = 0xE000000000000L;
    public static long SCOPE_MASK = -4222124650659841L;
    public static int[] IPV4_MULTICAST_ALLOCATION_RANGE = new int[]{-520093696, -268435457};
    public static long[][] IPV6_MULTICAST_ALLOCATION_RANGE = new long[][]{{-69805794224242688L, 0L}, {-69524319247532033L, -1L}};

    public static boolean isIPv6Preferred() {
        return Boolean.parseBoolean(System.getProperty("java.net.preferIPv6Addresses", "false")) || System.getProperty("java.net.preferIPv4Addresses") != null && !Boolean.parseBoolean(System.getProperty("java.net.preferIPv4Addresses"));
    }

    public static boolean isIPv4Preferred() {
        return Boolean.parseBoolean(System.getProperty("java.net.preferIPv4Addresses", "true"));
    }

    public static InetAddress getIPv4MulticastGroup(int hash) throws UnknownHostException {
        return NetworkUtils.getIPv4MulticastGroup(hash, IPV4_MULTICAST_ALLOCATION_RANGE[0], IPV4_MULTICAST_ALLOCATION_RANGE[1]);
    }

    public static InetAddress getIPv4MulticastGroup(int hash, int lowIp, int highIp) throws UnknownHostException {
        int port = (hash &= Integer.MAX_VALUE) % (highIp - lowIp + 1) + lowIp;
        byte[] ip = new byte[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            ip[i2] = (byte)(port >>> (3 - i2 << 3));
        }
        return InetAddress.getByAddress(ip);
    }

    public static InetAddress getIPv6MulticastGroup(int hash, long scope) throws UnknownHostException {
        return NetworkUtils.getIPv6MulticastGroup(hash, IPV6_MULTICAST_ALLOCATION_RANGE[0], IPV6_MULTICAST_ALLOCATION_RANGE[1], scope);
    }

    public static InetAddress getIPv6MulticastGroup(int hash, long[] lowIp, long[] highIp, long scope) throws UnknownHostException {
        byte[] ip = ArrayUtils.toByteArray(lowIp[0] & SCOPE_MASK | scope | (long)(hash &= Integer.MAX_VALUE), lowIp[1] | (long)hash);
        return InetAddress.getByAddress(ip);
    }

    public static int getMulticastPort(int hash) {
        int port = (hash &= Integer.MAX_VALUE) % 0xF000000 + -520093696;
        return port >>> 16;
    }

    public static long getIPv6Scope(InetAddress ip) {
        Long value;
        Long l2 = value = OSUtils.getLongProperty(H2O_SYSTEM_SCOPE_PARAM) != null ? OSUtils.getLongProperty(H2O_SYSTEM_SCOPE_PARAM) : OSUtils.getLongProperty(H2O_SYSTEM_SCOPE_PARAM, 16);
        if (value != null && ArrayUtils.equalsAny(value, SCOPE_IFACE_LOCAL, SCOPE_LINK_LOCAL, SCOPE_SITE_LOCAL, SCOPE_ORG_LOCAL, SCOPE_GLOBAL_LOCAL)) {
            return value;
        }
        if (ip.isLoopbackAddress()) {
            return SCOPE_IFACE_LOCAL;
        }
        if (ip.isLinkLocalAddress()) {
            return SCOPE_LINK_LOCAL;
        }
        if (ip.isSiteLocalAddress()) {
            return SCOPE_SITE_LOCAL;
        }
        return SCOPE_ORG_LOCAL;
    }

    public static boolean isUp(NetworkInterface iface) {
        try {
            return iface.isUp();
        }
        catch (SocketException e2) {
            return false;
        }
    }

    public static boolean isReachable(NetworkInterface iface, InetAddress address, int timeout) {
        try {
            return address.isReachable(iface, 0, timeout);
        }
        catch (IOException e2) {
            return false;
        }
    }

    public static int getLocalIpPingTimeout() {
        String value = System.getProperty(H2O_SYSTEM_LOCAL_IP_PING_TIMEOUT, "150");
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e2) {
            return 150;
        }
    }
}

