/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import water.H2O;
import water.Key;
import water.util.LabelledStringList;

public class RString {
    MMHashMap<String, Placeholder> _placeholders;
    LabelledStringList _parts = new LabelledStringList();
    Placeholder _parent;

    private static boolean isIdentChar(char x2) {
        return x2 == '$' || x2 >= 'a' && x2 <= 'z' || x2 >= 'A' && x2 <= 'Z' || x2 >= '0' && x2 <= '9' || x2 == '_';
    }

    private RString(String from, Placeholder parent) {
        this(from);
        this._parent = parent;
    }

    public RString(String from) {
        this._placeholders = new MMHashMap();
        LabelledStringList.Label cur = this._parts.begin();
        int start = 0;
        int end = 0;
        while (true) {
            if ((start = from.indexOf("%", end)) == -1) break;
            if (++start == from.length()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (from.charAt(start) == '%') {
                cur.insertAndAdvance(from.substring(end, start));
                end = start + 1;
                continue;
            }
            cur.insertAndAdvance(from.substring(end, start - 1));
            for (end = start; end < from.length() && RString.isIdentChar(from.charAt(end)); ++end) {
            }
            String pname = from.substring(start, end);
            if (end == from.length() || from.charAt(end) != '{') {
                this._placeholders.put2(pname, new Placeholder(cur.clone(), cur.clone()));
                continue;
            }
            start = end + 1;
            if ((end = from.indexOf("}", end)) == -1) {
                throw new ArrayIndexOutOfBoundsException("Missing } after replacement group");
            }
            this._placeholders.put2(pname, new Placeholder(cur.clone(), cur.clone(), from.substring(start, end)));
            ++end;
        }
        cur.insertAndAdvance(from.substring(end, from.length()));
    }

    public String toString() {
        return this._parts.toString();
    }

    private void clear() {
        throw H2O.unimpl();
    }

    public void replace(String what, Key key) {
        this.replace(what, key.user_allowed() ? key.toString() : "<code>" + key.toString() + "</code>");
    }

    public void replace(String what, Object with) {
        if (what.charAt(0) == '$') {
            throw new RuntimeException("$ is now control char that denotes URL encoding!");
        }
        for (Placeholder p2 : (ArrayList)this._placeholders.get(what)) {
            p2.end.insertAndAdvance(with.toString());
        }
        ArrayList ar = (ArrayList)this._placeholders.get("$" + what);
        if (ar == null) {
            return;
        }
        for (Placeholder p3 : ar) {
            try {
                p3.end.insertAndAdvance(URLEncoder.encode(with.toString(), "UTF-8"));
            }
            catch (IOException e2) {
                p3.end.insertAndAdvance(e2.toString());
            }
        }
    }

    private RString restartGroup(String what) {
        List all = (List)this._placeholders.get(what);
        assert (all.size() == 1);
        Placeholder result = (Placeholder)all.get(0);
        if (result.group == null) {
            throw new NoSuchElementException("Element " + what + " is not a group.");
        }
        result.group.clear();
        return result.group;
    }

    private void append() {
        if (this._parent == null) {
            throw new UnsupportedOperationException("Cannot append if no parent is specified.");
        }
        this._parent.end.insertAndAdvance(this.toString());
    }

    private static class MMHashMap<K, V>
    extends HashMap<K, ArrayList<V>> {
        private MMHashMap() {
        }

        void put2(K key, V val) {
            ArrayList<V> ar = (ArrayList<V>)this.get(key);
            if (ar == null) {
                ar = new ArrayList<V>();
                this.put(key, ar);
            }
            ar.add(val);
        }
    }

    private static class Placeholder {
        LabelledStringList.Label start;
        LabelledStringList.Label end;
        RString group;

        private Placeholder(LabelledStringList.Label start, LabelledStringList.Label end) {
            this.start = start;
            this.end = end;
            this.group = null;
        }

        private Placeholder(LabelledStringList.Label start, LabelledStringList.Label end, String from) {
            this.start = start;
            this.end = end;
            this.group = new RString(from, this);
        }
    }
}

