/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import water.H2O;
import water.Iced;
import water.util.Log;

public class ReflectionUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> Class<T> findActualClassParameter(Class clz, int parm) {
        Class parm_class = null;
        if (!(clz.getGenericSuperclass() instanceof ParameterizedType)) return Iced.class;
        Type[] handler_type_parms = ((ParameterizedType)clz.getGenericSuperclass()).getActualTypeArguments();
        if (handler_type_parms[parm] instanceof Class) {
            return (Class)handler_type_parms[parm];
        }
        if (handler_type_parms[parm] instanceof TypeVariable) {
            TypeVariable v2 = (TypeVariable)handler_type_parms[parm];
            Type t2 = v2.getBounds()[0];
            if (t2 instanceof Class) {
                return (Class)t2;
            }
            if (!(t2 instanceof ParameterizedType)) return parm_class;
            return (Class)((ParameterizedType)t2).getRawType();
        }
        if (handler_type_parms[parm] instanceof ParameterizedType) {
            return (Class)((ParameterizedType)handler_type_parms[parm]).getRawType();
        }
        String msg = "Iced parameter for handler: " + clz + " uses a type parameterization scheme that we don't yet handle: " + handler_type_parms[parm];
        Log.warn(msg);
        throw H2O.fail(msg);
    }

    public static Class findMethodParameterClass(Method method, int parm) {
        Class<?>[] clzes = method.getParameterTypes();
        if (clzes.length <= parm) {
            throw H2O.fail("Asked for the class of parameter number: " + parm + " of method: " + method + ", which only has: " + clzes.length + " parameters.");
        }
        return clzes[parm];
    }

    public static Class findMethodOutputClass(Method method) {
        return method.getReturnType();
    }

    public static Class findActualFieldClass(Class clz, Field f2) {
        Type generic_type = f2.getGenericType();
        if (!(generic_type instanceof TypeVariable)) {
            return f2.getType();
        }
        TypeVariable<Class<T>>[] tvs = clz.getSuperclass().getTypeParameters();
        TypeVariable tv = (TypeVariable)generic_type;
        String type_param_name = tv.getName();
        int which_tv = -1;
        for (int i2 = 0; i2 < tvs.length; ++i2) {
            if (!type_param_name.equals(tvs[i2].getName())) continue;
            which_tv = i2;
        }
        if (-1 == which_tv) {
            return f2.getType();
        }
        ParameterizedType generic_super = (ParameterizedType)clz.getGenericSuperclass();
        if (generic_super.getActualTypeArguments()[which_tv] instanceof Class) {
            return (Class)generic_super.getActualTypeArguments()[which_tv];
        }
        return ReflectionUtils.findActualFieldClass(clz.getSuperclass(), f2);
    }

    public static double asDouble(Object o2) {
        if (o2 == null) {
            return Double.NaN;
        }
        if (o2 instanceof Integer) {
            return ((Integer)o2).intValue();
        }
        if (o2 instanceof Long) {
            return ((Long)o2).longValue();
        }
        if (o2 instanceof Float) {
            return ((Float)o2).floatValue();
        }
        if (o2 instanceof Double) {
            return (Double)o2;
        }
        if (o2 instanceof Enum) {
            return ((Enum)o2).ordinal();
        }
        System.out.println("Do not know how to convert a " + o2.getClass() + " to a double");
        throw H2O.fail();
    }

    public static Field findNamedField(Object o2, String field_name) {
        Class<?> clz = o2.getClass();
        Field f2 = null;
        while (true) {
            try {
                f2 = clz.getDeclaredField(field_name);
                f2.setAccessible(true);
                return f2;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((clz = clz.getSuperclass()) != Object.class) continue;
                return null;
            }
            break;
        }
    }

    public static <T> T getFieldValue(Object o2, String fieldName) {
        Field f2 = ReflectionUtils.findNamedField(o2, fieldName);
        if (f2 == null) {
            return null;
        }
        try {
            return (T)f2.get(o2);
        }
        catch (IllegalAccessException e2) {
            return null;
        }
    }

    public static <T> T newInstance(String className, Class<T> instanceOf) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> cls = Class.forName(className);
        if (!instanceOf.isAssignableFrom(cls)) {
            throw new IllegalStateException("Class " + className + " is not an instance of " + instanceOf.getName() + ".");
        }
        return (T)cls.newInstance();
    }
}

