/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTimeZone;
import water.ExtensionManager;
import water.H2O;
import water.H2ONode;
import water.H2OSecurityManager;
import water.MRTask;
import water.Paxos;
import water.api.RestApiExtension;
import water.parser.ParseTime;
import water.util.OSUtils;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class ReproducibilityInformationUtils {
    public static TwoDimTable createNodeInformationTable() {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("node");
        colTypes.add("int");
        colFormat.add("%d");
        colHeaders.add("h2o");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("healthy");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("last_ping");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("num_cpus");
        colTypes.add("int");
        colFormat.add("%d");
        colHeaders.add("sys_load");
        colTypes.add("double");
        colFormat.add("%.5f");
        colHeaders.add("mem_value_size");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("free_mem");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("pojo_mem");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("swap_mem");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("free_disc");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("max_disc");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("pid");
        colTypes.add("int");
        colFormat.add("%d");
        colHeaders.add("num_keys");
        colTypes.add("int");
        colFormat.add("%d");
        colHeaders.add("tcps_active");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("open_fds");
        colTypes.add("int");
        colFormat.add("%d");
        colHeaders.add("rpcs_active");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("nthreads");
        colTypes.add("int");
        colFormat.add("%d");
        colHeaders.add("is_leader");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("total_mem");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("max_mem");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("java_version");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("jvm_launch_parameters");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("os_version");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("machine_physical_mem");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("machine_locale");
        colTypes.add("string");
        colFormat.add("%s");
        H2ONode[] members = H2O.CLOUD.members();
        int rows = members.length;
        TwoDimTable table = new TwoDimTable("Node Information", null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        NodeInfoTask info = (NodeInfoTask)new NodeInfoTask().doAllNodes();
        block0: for (int row = 0; row < rows; ++row) {
            int col = 0;
            table.set(row, col++, members[row].index());
            table.set(row, col++, members[row].getIpPortString());
            table.set(row, col++, Boolean.toString(members[row].isHealthy()));
            table.set(row, col++, members[row]._last_heard_from);
            table.set(row, col++, members[row]._heartbeat._num_cpus);
            table.set(row, col++, Float.valueOf(members[row]._heartbeat._system_load_average));
            table.set(row, col++, members[row]._heartbeat.get_kv_mem());
            table.set(row, col++, members[row]._heartbeat.get_free_mem());
            table.set(row, col++, members[row]._heartbeat.get_pojo_mem());
            table.set(row, col++, members[row]._heartbeat.get_swap_mem());
            table.set(row, col++, members[row]._heartbeat.get_free_disk());
            table.set(row, col++, members[row]._heartbeat.get_max_disk());
            table.set(row, col++, members[row]._heartbeat._pid);
            table.set(row, col++, members[row]._heartbeat._keys);
            table.set(row, col++, Character.valueOf(members[row]._heartbeat._tcps_active));
            table.set(row, col++, members[row]._heartbeat._process_num_open_fds);
            table.set(row, col++, Character.valueOf(members[row]._heartbeat._rpcs));
            table.set(row, col++, members[row]._heartbeat._nthreads);
            table.set(row, col++, Boolean.toString(row == H2O.CLOUD.leader().index()));
            for (int i2 = 0; i2 < rows; ++i2) {
                if (members[row].index() != info.index[i2]) continue;
                table.set(row, col++, info.totalMem[i2]);
                table.set(row, col++, info.maxMem[i2]);
                table.set(row, col++, info.javaVersion[i2]);
                table.set(row, col++, info.jvmLaunchParameters[i2]);
                table.set(row, col++, info.osVersion[i2]);
                table.set(row, col++, info.machinePhysicalMem[i2]);
                table.set(row, col++, info.machineLocale[i2]);
                continue block0;
            }
        }
        return table;
    }

    public static TwoDimTable createClusterConfigurationTable() {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("H2O cluster uptime");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("H2O cluster timezone");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("H2O data parsing timezone");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("H2O cluster version");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("H2O cluster version age");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("H2O cluster name");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("H2O cluster total nodes");
        colTypes.add("int");
        colFormat.add("%d");
        colHeaders.add("H2O cluster free memory");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("H2O cluster total cores");
        colTypes.add("int");
        colFormat.add("%d");
        colHeaders.add("H2O cluster allowed cores");
        colTypes.add("int");
        colFormat.add("%d");
        colHeaders.add("H2O cluster status");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("H2O internal security");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("H2O API Extensions");
        colTypes.add("string");
        colFormat.add("%s");
        H2ONode[] members = H2O.CLOUD.members();
        long freeMem = 0L;
        int totalCores = 0;
        int clusterAllowedCores = 0;
        int unhealthlyNodes = 0;
        boolean locked = Paxos._cloudLocked;
        for (int i2 = 0; i2 < members.length; ++i2) {
            freeMem += members[i2]._heartbeat.get_free_mem();
            totalCores += members[i2]._heartbeat._num_cpus;
            clusterAllowedCores += members[i2]._heartbeat._cpus_allowed;
            if (members[i2].isHealthy()) continue;
            ++unhealthlyNodes;
        }
        String status = locked ? "locked" : "accepting new members";
        status = status + (unhealthlyNodes > 0 ? ", " + unhealthlyNodes + " nodes are not healthly" : ", healthly");
        String apiExtensions = "";
        for (RestApiExtension ext : ExtensionManager.getInstance().getRestApiExtensions()) {
            if (apiExtensions.isEmpty()) {
                apiExtensions = apiExtensions + ext.getName();
                continue;
            }
            apiExtensions = apiExtensions + ", " + ext.getName();
        }
        boolean rows = true;
        TwoDimTable table = new TwoDimTable("Cluster Configuration", null, new String[1], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        int row = 0;
        int col = 0;
        table.set(row, col++, System.currentTimeMillis() - H2O.START_TIME_MILLIS.get());
        table.set(row, col++, DateTimeZone.getDefault().toString());
        table.set(row, col++, ParseTime.getTimezone().toString());
        table.set(row, col++, H2O.ABV.projectVersion());
        table.set(row, col++, PrettyPrint.toAge(H2O.ABV.compiledOnDate(), new Date()));
        table.set(row, col++, H2O.ARGS.name);
        table.set(row, col++, H2O.CLOUD.size());
        table.set(row, col++, freeMem);
        table.set(row, col++, totalCores);
        table.set(row, col++, clusterAllowedCores);
        table.set(row, col++, status);
        table.set(row, col++, Boolean.toString(H2OSecurityManager.instance().securityEnabled));
        table.set(row, col++, apiExtensions);
        return table;
    }

    public static class NodeInfoTask
    extends MRTask<NodeInfoTask> {
        private long[] totalMem;
        private long[] maxMem;
        private String[] javaVersion;
        private String[] jvmLaunchParameters;
        private String[] osVersion;
        private long[] machinePhysicalMem;
        private String[] machineLocale;
        private int[] index;

        @Override
        public void setupLocal() {
            this.totalMem = new long[H2O.CLOUD.size()];
            this.maxMem = new long[H2O.CLOUD.size()];
            Arrays.fill(this.totalMem, -1L);
            Arrays.fill(this.maxMem, -1L);
            this.javaVersion = new String[H2O.CLOUD.size()];
            this.jvmLaunchParameters = new String[H2O.CLOUD.size()];
            this.osVersion = new String[H2O.CLOUD.size()];
            this.machinePhysicalMem = new long[H2O.CLOUD.size()];
            this.machineLocale = new String[H2O.CLOUD.size()];
            this.index = new int[H2O.CLOUD.size()];
            Arrays.fill(this.index, -1);
            if (H2O.ARGS.client) {
                return;
            }
            Runtime runtime = Runtime.getRuntime();
            this.totalMem[H2O.SELF.index()] = runtime.totalMemory();
            this.maxMem[H2O.SELF.index()] = runtime.maxMemory();
            this.javaVersion[H2O.SELF.index()] = "Java " + System.getProperty("java.version") + " (from " + System.getProperty("java.vendor") + ")";
            this.jvmLaunchParameters[H2O.SELF.index()] = ManagementFactory.getRuntimeMXBean().getInputArguments().toString();
            this.osVersion[H2O.SELF.index()] = System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")";
            this.machinePhysicalMem[H2O.SELF.index()] = OSUtils.getTotalPhysicalMemory();
            this.machineLocale[H2O.SELF.index()] = Locale.getDefault().toString();
            this.index[H2O.SELF.index()] = H2O.SELF.index();
        }

        @Override
        public void reduce(NodeInfoTask other) {
            for (int i2 = 0; i2 < H2O.CLOUD.size(); ++i2) {
                if (other.index[i2] > -1) {
                    this.index[i2] = other.index[i2];
                }
                if (other.totalMem[i2] > -1L) {
                    this.totalMem[i2] = other.totalMem[i2];
                }
                if (other.maxMem[i2] > -1L) {
                    this.maxMem[i2] = other.maxMem[i2];
                }
                if (other.javaVersion != null) {
                    this.javaVersion[i2] = other.javaVersion[i2];
                }
                if (other.jvmLaunchParameters[i2] != null) {
                    this.jvmLaunchParameters[i2] = other.jvmLaunchParameters[i2];
                }
                if (other.osVersion != null) {
                    this.osVersion[i2] = other.osVersion[i2];
                }
                if (other.machinePhysicalMem[i2] > -1L) {
                    this.machinePhysicalMem[i2] = other.machinePhysicalMem[i2];
                }
                if (other.machineLocale[i2] == null) continue;
                this.machineLocale[i2] = other.machineLocale[i2];
            }
        }
    }
}

